/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class TextFieldWithDefaultHandler {
    private CellRendererAdapter cellRendererAdapter;
    private ValueModel defaultValueHolder;
    private boolean locked;
    private boolean showDefaultValue;
    private ValueModel subjectHolder;
    private JTextField textField;
    private boolean valueSet;

    public TextFieldWithDefaultHandler(JTextField textField, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder) {
        this(textField, subjectHolder, valueHolder, defaultValueHolder, null);
    }

    public TextFieldWithDefaultHandler(JTextField textField, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, CellRendererAdapter cellRendererAdapter) {
        this.initialize(textField, subjectHolder, valueHolder, defaultValueHolder, cellRendererAdapter);
    }

    private CellRendererAdapter buildCellRendererAdapter() {
        return new AbstractCellRendererAdapter(){

            public String buildText(Object value) {
                return (String)value;
            }
        };
    }

    private Document buildDocument(PropertyValueModel valueHolder, Document originalDocument) {
        return new DocumentAdapter(this.buildValueHolder(valueHolder), originalDocument);
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    TextFieldWithDefaultHandler.this.updateTextFieldOnFocusGained();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    TextFieldWithDefaultHandler.this.updateTextFieldOnFocusLost();
                }
            }
        };
    }

    private PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                TextFieldWithDefaultHandler.this.updateTextFieldForegroundColor((String)e.getNewValue());
            }
        };
    }

    private PropertyChangeListener buildSubjectPropertyChangeListener() {
        return new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent e) {
                if (TextFieldWithDefaultHandler.this.locked) {
                    return;
                }
                try {
                    TextFieldWithDefaultHandler.this.locked = true;
                    TextFieldWithDefaultHandler.this.showDefaultValue = TextFieldWithDefaultHandler.this.subjectHolder.getValue() == null;
                    if (TextFieldWithDefaultHandler.this.showDefaultValue) {
                        TextFieldWithDefaultHandler.this.valueSet = false;
                    }
                    if (!TextFieldWithDefaultHandler.this.valueSet) {
                        String defaultValue = (String)TextFieldWithDefaultHandler.this.defaultValue();
                        TextFieldWithDefaultHandler.this.textField.setText(defaultValue);
                        TextFieldWithDefaultHandler.this.updateTextFieldForegroundColor(defaultValue);
                    }
                }
                finally {
                    TextFieldWithDefaultHandler.this.locked = false;
                    TextFieldWithDefaultHandler.this.valueSet = false;
                    TextFieldWithDefaultHandler.this.showDefaultValue = false;
                }
            }
        };
    }

    private PropertyValueModel buildValueHolder(PropertyValueModel valueHolder) {
        InternalPropertyValueModel holder = new InternalPropertyValueModel(valueHolder);
        holder.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        return holder;
    }

    private Object defaultValue() {
        if (this.subjectHolder.getValue() == null) {
            return "";
        }
        Object defaultValue = this.defaultValueHolder.getValue();
        if (StringTools.stringIsEmpty((String)((String)defaultValue))) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(defaultValue);
        sb.append(')');
        return sb.toString();
    }

    public final JTextField getTextField() {
        return this.textField;
    }

    private void initialize(JTextField textField, ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, CellRendererAdapter cellRendererAdapter) {
        this.textField = textField;
        this.defaultValueHolder = defaultValueHolder;
        this.subjectHolder = subjectHolder;
        this.cellRendererAdapter = cellRendererAdapter != null ? cellRendererAdapter : this.buildCellRendererAdapter();
        this.subjectHolder.addPropertyChangeListener("value", this.buildSubjectPropertyChangeListener());
        if (valueHolder != null) {
            Document document = this.buildDocument(valueHolder, textField.getDocument());
            textField.setDocument(new PlainDocument());
            textField.setDocument(document);
        }
        textField.addFocusListener(this.buildFocusListener());
        this.updateTextFieldForegroundColor(textField.getText());
    }

    private void updateTextFieldForegroundColor(String text) {
        if (this.defaultValue().equals(text)) {
            this.textField.setForeground(Color.GRAY);
        } else {
            this.textField.setForeground(UIManager.getColor("TextField.foreground"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextFieldOnFocusGained() {
        if (this.textField.getText().equals(this.defaultValue())) {
            this.locked = true;
            try {
                this.textField.setText("");
                this.textField.setForeground(UIManager.getColor("TextField.foreground"));
            }
            finally {
                this.locked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextFieldOnFocusLost() {
        if (this.textField.getText().trim().length() == 0) {
            this.locked = true;
            try {
                this.textField.setText((String)this.defaultValue());
                this.textField.setForeground(Color.GRAY);
            }
            finally {
                this.locked = false;
            }
        }
    }

    private final class InternalPropertyValueModel
    extends TransformationPropertyValueModel {
        InternalPropertyValueModel(PropertyValueModel valueHolder) {
            super(valueHolder);
        }

        private String formatNewValue(String value) {
            return value == null ? null : TextFieldWithDefaultHandler.this.cellRendererAdapter.buildText(value);
        }

        protected Object reverseTransform(Object value) {
            return TextFieldWithDefaultHandler.this.defaultValue().equals(value) ? null : value;
        }

        public void setValue(Object value) {
            if (!TextFieldWithDefaultHandler.this.locked) {
                super.setValue(value);
            }
        }

        protected Object transform(Object value) {
            if (TextFieldWithDefaultHandler.this.showDefaultValue) {
                return TextFieldWithDefaultHandler.this.defaultValue();
            }
            return TextFieldWithDefaultHandler.this.textField.hasFocus() || value != null ? this.formatNewValue((String)value) : TextFieldWithDefaultHandler.this.defaultValue();
        }

        protected void valueChanged(PropertyChangeEvent e) {
            TextFieldWithDefaultHandler.this.valueSet = true;
            super.valueChanged(e);
        }
    }
}

