/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public class CollectionListValueModelAdapter
extends AbstractModel
implements ListValueModel {
    protected CollectionValueModel collectionHolder;
    protected CollectionChangeListener collectionChangeListener;
    protected ArrayList list;

    public CollectionListValueModelAdapter(CollectionValueModel collectionHolder) {
        if (collectionHolder == null) {
            throw new NullPointerException();
        }
        this.collectionHolder = collectionHolder;
    }

    protected void initialize() {
        super.initialize();
        this.collectionChangeListener = this.buildCollectionChangeListener();
        this.list = new ArrayList();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionListValueModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionListValueModelAdapter.this.itemsRemoved(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionListValueModelAdapter.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public Object getValue() {
        return new ReadOnlyListIterator((List)this.list);
    }

    public void addItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    public void addItems(int index, List items) {
        throw new UnsupportedOperationException();
    }

    public Object removeItem(int index) {
        throw new UnsupportedOperationException();
    }

    public List removeItems(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public Object replaceItem(int index, Object item) {
        throw new UnsupportedOperationException();
    }

    public List replaceItems(int index, List items) {
        throw new UnsupportedOperationException();
    }

    public Object getItem(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public void addListChangeListener(ListChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listener);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        if (listName == "value" && this.hasNoListeners()) {
            this.engageModel();
        }
        super.addListChangeListener(listName, listener);
    }

    public void removeListChangeListener(ListChangeListener listener) {
        super.removeListChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        super.removeListChangeListener(listName, listener);
        if (listName == "value" && this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("value");
    }

    protected boolean hasNoListeners() {
        return !this.hasListeners();
    }

    protected int lastIdentityIndexOf(Object o) {
        return this.lastIdentityIndexOf(o, this.list.size());
    }

    protected int lastIdentityIndexOf(Object o, int end) {
        int i = end;
        while (i-- > 0) {
            if (this.list.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    protected void buildList() {
        Iterator stream = (Iterator)this.collectionHolder.getValue();
        if (stream.hasNext()) {
            this.list.ensureCapacity(this.collectionHolder.size());
            while (stream.hasNext()) {
                this.list.add(stream.next());
            }
            this.postBuildList();
        }
    }

    protected void postBuildList() {
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("value", this.collectionChangeListener);
        this.buildList();
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("value", this.collectionChangeListener);
        this.list.clear();
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        List addedItems = CollectionTools.list((Iterator)e.items());
        int index = this.indexToAddItems();
        this.list.addAll(index, addedItems);
        this.fireItemsAdded("value", index, addedItems);
    }

    protected int indexToAddItems() {
        return this.list.size();
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        Iterator stream = e.items();
        while (stream.hasNext()) {
            Object removedItem = stream.next();
            int index = this.lastIdentityIndexOf(removedItem);
            this.list.remove(index);
            this.fireItemRemoved("value", index, removedItem);
        }
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        if (!this.list.isEmpty()) {
            ArrayList removedItems = this.list;
            this.list = new ArrayList();
            this.fireItemsRemoved("value", 0, removedItems);
        }
        this.buildList();
        if (!this.list.isEmpty()) {
            this.fireItemsAdded("value", 0, this.list);
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.collectionHolder);
    }
}

