/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class AWTExceptionHandler {
    private static GlobalHandler globalHandler = GlobalHandler.DEFAULT_INSTANCE;
    public static final String AWT_EXCEPTION_HANDLER_PROPERTY_NAME = "sun.awt.exception.handler";

    public static void register() {
        System.setProperty(AWT_EXCEPTION_HANDLER_PROPERTY_NAME, AWTExceptionHandler.class.getName());
    }

    public static synchronized void setGlobalHandler(GlobalHandler handler) {
        globalHandler = handler == null ? GlobalHandler.DEFAULT_INSTANCE : handler;
    }

    public void handle(Throwable t) {
        try {
            globalHandler.handle(t);
        }
        catch (Throwable t2) {
            this.handle(t, t2);
        }
    }

    private void handle(Throwable original, Throwable subsequent) {
        try {
            System.err.println("Problem occurred while handling AWT Event Problem:");
            subsequent.printStackTrace();
            System.err.println();
            System.err.println("Original exception:");
            original.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return ClassTools.shortClassNameForObject((Object)this);
    }

    public static interface GlobalHandler {
        public static final GlobalHandler DEFAULT_INSTANCE = new GlobalHandler(){

            public void handle(Throwable t) {
                t.printStackTrace();
            }

            public String toString() {
                return "DefaultGlobalHandler";
            }
        };

        public void handle(Throwable var1);
    }
}

