/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.SessionCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class BrokerCreationDialog
extends AbstractValidatingDialog {
    private JCheckBox useServerPlatformCheckBox;
    private ComboBoxModel serverPlatformComboBoxModel;
    private String previousServerClassName;
    private JTextField nameTextField;
    private final PropertyValueModel stringHolder;
    private final PropertyValueModel serverPlatformHolder;
    private final CollectionValueModel itemHolder;
    private final ObjectListSelectionModel selectionModel;
    private final Collection sessionBrokerNames;

    BrokerCreationDialog(WorkbenchContext context, CollectionValueModel itemHolder, ObjectListSelectionModel selectionModel, PropertyValueModel stringHolder, PropertyValueModel serverPlatformHolder, Collection sessionBrokerNames) {
        super(context);
        this.stringHolder = stringHolder;
        this.serverPlatformHolder = serverPlatformHolder;
        this.itemHolder = itemHolder;
        this.selectionModel = selectionModel;
        this.sessionBrokerNames = sessionBrokerNames;
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    private Document buildNameDocumentAdapter() {
        return new DocumentAdapter(this.stringHolder);
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("BROKER_CREATION_DIALOG_TITLE"));
        boolean showSessionsList = ((Iterator)this.itemHolder.getValue()).hasNext();
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel nameLabel = SwingComponentFactory.buildLabel("BROKER_CREATION_DIALOG_NAME_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)nameLabel, constraints);
        this.nameTextField = new JTextField(this.buildNameDocumentAdapter(), null, 20);
        this.nameTextField.getDocument().addDocumentListener(this.buildNameFieldDocumentListener());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)this.nameTextField, constraints);
        nameLabel.setLabelFor(this.nameTextField);
        JPanel serverPlatformPanel = this.buildServerPlatformPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 0, 0, 0);
        this.helpManager().addTopicID(serverPlatformPanel, this.helpTopicId() + ".serverPlatform");
        panel.add((Component)serverPlatformPanel, constraints);
        if (showSessionsList) {
            this.buildSessionsList(panel);
        }
        this.helpManager().addTopicID(panel, this.helpTopicId() + ".name");
        return panel;
    }

    private DocumentListener buildNameFieldDocumentListener() {
        return new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                BrokerCreationDialog.this.updateOKAction();
            }

            public void removeUpdate(DocumentEvent e) {
                BrokerCreationDialog.this.updateOKAction();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    private ComboBoxModel buildServerPlatformComboBoxModel() {
        SimpleCollectionValueModel platformsHolder = new SimpleCollectionValueModel(CollectionTools.vector((Iterator)this.serverPlatforms()));
        return new ComboBoxModelAdapter(platformsHolder, this.serverPlatformHolder);
    }

    private Iterator serverPlatforms() {
        SortedSet servers = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
        String serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
        servers.remove(ClassTools.shortNameForClassNamed((String)serverClassName));
        return servers.iterator();
    }

    boolean usesServerPlatform() {
        return this.useServerPlatformCheckBox.isSelected();
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String serverClassName;
                boolean checked = ((JCheckBox)e.getSource()).isSelected();
                if (!checked) {
                    BrokerCreationDialog.this.previousServerClassName = (String)BrokerCreationDialog.this.serverPlatformComboBoxModel.getSelectedItem();
                    serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
                    serverClassName = ClassTools.shortNameForClassNamed((String)serverClassName);
                } else {
                    if (BrokerCreationDialog.this.previousServerClassName == null) {
                        BrokerCreationDialog.this.previousServerClassName = "WebLogic_10_Platform";
                    }
                    serverClassName = BrokerCreationDialog.this.previousServerClassName;
                }
                BrokerCreationDialog.this.serverPlatformComboBoxModel.setSelectedItem(serverClassName);
            }
        };
    }

    private JPanel buildServerPlatformPanel() {
        this.useServerPlatformCheckBox = new JCheckBox();
        this.useServerPlatformCheckBox.setText(this.resourceRepository().getString("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setMnemonic(this.resourceRepository().getMnemonic("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.addActionListener(this.buildServerPlatformAction());
        final JPanel subPane = this.buildServerPlatformSubPane();
        subPane.setEnabled(false);
        this.useServerPlatformCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                subPane.setEnabled(checkBox.isSelected());
            }
        });
        this.updateServerPlatformWidgets();
        return new GroupBox(this.useServerPlatformCheckBox, (JComponent)subPane);
    }

    private void updateServerPlatformWidgets() {
        boolean selected;
        String serverClassName = (String)this.serverPlatformComboBoxModel.getSelectedItem();
        boolean bl = selected = serverClassName != null;
        if (selected) {
            ServerPlatformAdapter noServerPlatform = NullServerPlatformAdapter.instance();
            String noServerPlatformClassName = ClassTools.shortNameForClassNamed((String)noServerPlatform.getServerClassName());
            selected = !serverClassName.equals(noServerPlatformClassName);
        }
        this.useServerPlatformCheckBox.setSelected(selected);
    }

    private ListCellRenderer buildServerPlatformRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                if (value == null) {
                    return "";
                }
                return BrokerCreationDialog.this.resourceRepository().getString((String)value);
            }
        };
    }

    private JPanel buildServerPlatformSubPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane container = new Pane(new GridBagLayout());
        JLabel platformLabel = SwingComponentFactory.buildLabel("SERVER_PLATFORM_COMBO_BOX", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)platformLabel, constraints);
        this.serverPlatformComboBoxModel = this.buildServerPlatformComboBoxModel();
        JComboBox serverPlatformComboBox = new JComboBox(this.serverPlatformComboBoxModel);
        serverPlatformComboBox.setRenderer(this.buildServerPlatformRenderer());
        String platformName = this.preferences().get("platform.server", null);
        serverPlatformComboBox.setSelectedItem(platformName);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        container.add(serverPlatformComboBox, constraints);
        platformLabel.setLabelFor(serverPlatformComboBox);
        return container;
    }

    private void buildSessionsList(JPanel panel) {
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel sessionsListLabel = SwingComponentFactory.buildLabel("BROKER_CREATION_DIALOG_SESSIONS_LIST", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)sessionsListLabel, constraints);
        CheckList sessionsList = new CheckList(this.itemHolder, (ListSelectionModel)this.selectionModel, this.buildLabelDecorator());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)sessionsList, constraints);
        sessionsListLabel.setLabelFor(sessionsList);
    }

    private CellRendererAdapter buildLabelDecorator() {
        return new SessionCellRendererAdapter(this.resourceRepository());
    }

    private void updateOKAction() {
        String sessionName = this.nameTextField.getText().trim();
        boolean valid = sessionName.length() > 0 && !this.sessionBrokerNames.contains(sessionName);
        this.getOKAction().setEnabled(valid);
        if (valid) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("BROKER_CREATION_DIALOG_INVALID_NAME");
        }
    }

    private String buildUniqueSessionBrokerName() {
        String sessionBrokerName = this.preferences().get("new name.broker", this.resourceRepository().getString("BROKER_CREATION_DIALOG_NEW_NAME"));
        return NameTools.uniqueNameFor((String)sessionBrokerName, (Collection)this.sessionBrokerNames);
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.setText(this.buildUniqueSessionBrokerName());
        this.nameTextField.selectAll();
    }

    protected String helpTopicId() {
        return "dialog.sessionBrokerCreation";
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

