/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.internal.sessions.factories.model.login.EISLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequencingAdapter;

public final class EISLoginAdapter
extends LoginAdapter {
    public static final String CONNECTION_FACTORY_URL_PROPERTY = "connectionFactoryURL";
    public static final String CONNECTION_SPEC_CLASS_PROPERTY = "connectionSpecClass";

    EISLoginAdapter(SCAdapter parent, EISLoginConfig scConfig) {
        super(parent, (LoginConfig)scConfig);
    }

    protected EISLoginAdapter(SCAdapter parent) {
        super(parent);
    }

    protected Object buildModel() {
        return new EISLoginConfig();
    }

    protected SequencingAdapter buildSequencing() {
        SequencingAdapter sequencing = super.buildSequencing();
        this.login().setSequencingConfig((SequencingConfig)sequencing.getModel());
        return sequencing;
    }

    protected String getDefaultPlatformClassName() {
        String platformName = this.preferences().get("platform.eis", "AQPlatform");
        return DataSource.getClassNameForEisPlatform(platformName);
    }

    public String getConnectionFactoryURL() {
        return this.login().getConnectionFactoryURL();
    }

    public void setPlatformClass(String platformClassName) {
        super.setPlatformClass(platformClassName);
        this.setDefaultConnectionSpecClassName(platformClassName);
    }

    private void setDefaultConnectionSpecClassName(String platformClassName) {
        String connectionSpecClassName = EisPlatformManager.instance().getRuntimeConnectionSpecClassName(platformClassName);
        this.setConnectionSpecClassName(connectionSpecClassName);
    }

    public void setConnectionFactoryURL(String url) {
        String old = this.login().getConnectionFactoryURL();
        this.login().setConnectionFactoryURL(url);
        this.firePropertyChanged(CONNECTION_FACTORY_URL_PROPERTY, old, url);
    }

    public String getConnectionSpecClassName() {
        return this.login().getConnectionSpecClass();
    }

    public void setConnectionSpecClassName(String name) {
        String old = this.login().getConnectionSpecClass();
        this.login().setConnectionSpecClass(name);
        this.firePropertyChanged(CONNECTION_SPEC_CLASS_PROPERTY, old, name);
    }

    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append(", ").append(this.getConnectionSpecClassName());
    }

    boolean platformIsEis() {
        return true;
    }

    private final EISLoginConfig login() {
        return (EISLoginConfig)this.getModel();
    }
}

