/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.FirstArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.SecondArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;

final class BasicExpressionPanel
extends AbstractPanel {
    private PropertyValueModel basicExpressionHolder;
    private PropertyValueModel firstArgumentHolder;
    private PropertyValueModel secondArgumentHolder;
    private FirstArgumentPanel firstArgumentPanel;
    private SecondArgumentPanel secondArgumentPanel;
    private JComboBox operatorComboBox;
    private ValueModel basicExpressionEnablerModel;
    public static final String EQUAL = "EQUAL";
    public static final String EQUALS_IGNORE_CASE = "EQUALS IGNORE CASE";
    public static final String GREATER_THAN = "GREATER THAN";
    public static final String GREATER_THAN_EQUAL = "GREATER THAN EQUAL";
    public static final String LESS_THAN = "LESS THAN";
    public static final String LESS_THAN_EQUAL = "LESS THAN EQUAL";
    public static final String LIKE = "LIKE";
    public static final String LIKE_IGNORE_CASE = "LIKE IGNORE CASE";
    public static final String NOT_EQUAL = "NOT EQUAL";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String IS_NULL = "IS NULL";
    public static final String NOT_NULL = "NOT NULL";

    BasicExpressionPanel(PropertyValueModel selectedExpressionHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.initialize(selectedExpressionHolder);
    }

    private void initialize(PropertyValueModel selectedExpressionHolder) {
        this.basicExpressionHolder = this.buildBasicExpressionHolder(selectedExpressionHolder);
        this.firstArgumentHolder = this.buildFirstArgumentHolder();
        this.secondArgumentHolder = this.buildSecondArgumentHolder();
        this.basicExpressionEnablerModel = this.buildBasicExpressionEnablerModel();
        this.initializeLayout();
    }

    private PropertyValueModel buildFirstArgumentHolder() {
        return new PropertyAspectAdapter(this.basicExpressionHolder, "firstArgument"){

            protected Object getValueFromSubject() {
                return ((MWBasicExpression)this.subject).getFirstArgument();
            }
        };
    }

    private PropertyValueModel buildSecondArgumentHolder() {
        return new PropertyAspectAdapter(this.basicExpressionHolder, "secondArgument"){

            protected Object getValueFromSubject() {
                return ((MWBasicExpression)this.subject).getSecondArgument();
            }
        };
    }

    private PropertyValueModel buildBasicExpressionHolder(PropertyValueModel selectedExpressionHolder) {
        return new FilteringPropertyValueModel(selectedExpressionHolder){

            protected boolean accept(Object value) {
                return value instanceof MWBasicExpression;
            }
        };
    }

    private ValueModel buildBasicExpressionEnablerModel() {
        return new PropertyAspectAdapter(this.basicExpressionHolder){

            protected Object buildValue() {
                if (BasicExpressionPanel.this.basicExpressionHolder.getValue() == null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
    }

    private Iterator allowableOperatorTypes() {
        ArrayList<String> operatorTypes = new ArrayList<String>();
        operatorTypes.add(EQUAL);
        operatorTypes.add(NOT_EQUAL);
        operatorTypes.add(EQUALS_IGNORE_CASE);
        operatorTypes.add(GREATER_THAN);
        operatorTypes.add(GREATER_THAN_EQUAL);
        operatorTypes.add(LESS_THAN);
        operatorTypes.add(LESS_THAN_EQUAL);
        operatorTypes.add(LIKE);
        operatorTypes.add(NOT_LIKE);
        operatorTypes.add(LIKE_IGNORE_CASE);
        operatorTypes.add(IS_NULL);
        operatorTypes.add(NOT_NULL);
        return operatorTypes.iterator();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.firstArgumentPanel = new FirstArgumentPanel(this.firstArgumentHolder, this.basicExpressionEnablerModel, this.getWorkbenchContextHolder());
        this.firstArgumentPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("FIRST_ARGUMENT_PANEL_TITLE.title")));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.firstArgumentPanel, constraints);
        ArrayList<JComponent> enablingComponents = new ArrayList<JComponent>();
        JPanel operatorPanel = new JPanel(new GridBagLayout());
        JLabel operatorLabel = new JLabel(this.resourceRepository().getString("OPERATOR_LABEL:"));
        operatorLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("OPERATOR_LABEL:"));
        enablingComponents.add(operatorLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 5, 5);
        operatorPanel.add((Component)operatorLabel, constraints);
        this.operatorComboBox = this.buildOperatorComboBox();
        enablingComponents.add(this.operatorComboBox);
        new ComponentEnabler(this.basicExpressionEnablerModel, enablingComponents);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        constraints.insets = new Insets(5, 5, 5, 5);
        operatorLabel.setLabelFor(this.operatorComboBox);
        operatorPanel.add((Component)this.operatorComboBox, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)operatorPanel, constraints);
        this.secondArgumentPanel = new SecondArgumentPanel(this.secondArgumentHolder, this.basicExpressionHolder, this.getWorkbenchContextHolder());
        this.secondArgumentPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("SECOND_ARGUMENT_PANEL_TITLE.title")));
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.secondArgumentPanel, constraints);
        Dimension dimension1 = this.firstArgumentPanel.getPreferredSize();
        Dimension dimension2 = this.secondArgumentPanel.getPreferredSize();
        dimension1.width = Math.max(dimension1.width, dimension2.height);
        dimension1.height = Math.max(dimension1.height, dimension2.height) + 8;
        this.firstArgumentPanel.setMinimumSize(dimension1);
        this.firstArgumentPanel.setPreferredSize(dimension1);
        this.secondArgumentPanel.setMinimumSize(dimension1);
        this.secondArgumentPanel.setPreferredSize(dimension1);
    }

    private JComboBox buildOperatorComboBox() {
        JComboBox comboBox = new JComboBox();
        comboBox.setModel(this.buildOperatorComboBoxModel());
        return comboBox;
    }

    private ComboBoxModel buildOperatorComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildOperatorTypeCollectionHolder(), this.buildOperatorAdapter());
    }

    private CollectionValueModel buildOperatorTypeCollectionHolder() {
        return new AbstractReadOnlyCollectionValueModel(){

            public Object getValue() {
                return BasicExpressionPanel.this.allowableOperatorTypes();
            }
        };
    }

    private PropertyValueModel buildOperatorAdapter() {
        return new PropertyAspectAdapter(this.basicExpressionHolder, "operatorType"){

            protected Object getValueFromSubject() {
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.EQUAL) {
                    return BasicExpressionPanel.EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.NOT_EQUAL) {
                    return BasicExpressionPanel.NOT_EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.EQUALS_IGNORE_CASE) {
                    return BasicExpressionPanel.EQUALS_IGNORE_CASE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.GREATER_THAN) {
                    return BasicExpressionPanel.GREATER_THAN;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.GREATER_THAN_EQUAL) {
                    return BasicExpressionPanel.GREATER_THAN_EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LESS_THAN) {
                    return BasicExpressionPanel.LESS_THAN;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LESS_THAN_EQUAL) {
                    return BasicExpressionPanel.LESS_THAN_EQUAL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LIKE) {
                    return BasicExpressionPanel.LIKE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.NOT_LIKE) {
                    return BasicExpressionPanel.NOT_LIKE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.LIKE_IGNORE_CASE) {
                    return BasicExpressionPanel.LIKE_IGNORE_CASE;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.IS_NULL) {
                    return BasicExpressionPanel.IS_NULL;
                }
                if (((MWBasicExpression)this.subject).getOperatorType() == BasicExpressionPanel.NOT_NULL) {
                    return BasicExpressionPanel.NOT_NULL;
                }
                throw new IllegalArgumentException();
            }

            protected void setValueOnSubject(Object value) {
                if (value == BasicExpressionPanel.EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.EQUAL);
                } else if (value == BasicExpressionPanel.NOT_EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.NOT_EQUAL);
                } else if (value == BasicExpressionPanel.EQUALS_IGNORE_CASE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.EQUALS_IGNORE_CASE);
                } else if (value == BasicExpressionPanel.GREATER_THAN) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.GREATER_THAN);
                } else if (value == BasicExpressionPanel.GREATER_THAN_EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.GREATER_THAN_EQUAL);
                } else if (value == BasicExpressionPanel.LESS_THAN) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LESS_THAN);
                } else if (value == BasicExpressionPanel.LESS_THAN_EQUAL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LESS_THAN_EQUAL);
                } else if (value == BasicExpressionPanel.LIKE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LIKE);
                } else if (value == BasicExpressionPanel.NOT_LIKE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.NOT_LIKE);
                } else if (value == BasicExpressionPanel.LIKE_IGNORE_CASE) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.LIKE_IGNORE_CASE);
                } else if (value == BasicExpressionPanel.IS_NULL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.IS_NULL);
                } else if (value == BasicExpressionPanel.NOT_NULL) {
                    ((MWBasicExpression)this.subject).setOperatorType(BasicExpressionPanel.NOT_NULL);
                }
            }
        };
    }
}

