/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWDescriptorMultiTableInfoPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWSecondaryTableHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ReferenceCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.ColumnPairsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.LabelPanel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class MultiTableInfoPropertiesPage
extends ScrollablePropertiesPage {
    public static final int EDITOR_WEIGHT = 10;
    private PropertyValueModel selectedSecondaryTableHolder;
    private PropertyValueModel primaryKeysHaveSameNameValueHolder;
    private ListChooser referenceListChooser;
    private PropertyValueModel multiTableInfoPolicyHolder;
    private PropertyValueModel primaryTableHolder;
    private PropertyValueModel selectedTableReferenceSelectionHolder;

    public MultiTableInfoPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel selectionNodeHolder) {
        super.initialize(selectionNodeHolder);
        this.multiTableInfoPolicyHolder = this.buildMultiTableInfoPolicyHolder();
        this.primaryTableHolder = this.buildPrimaryTableHolder();
        this.selectedSecondaryTableHolder = new SimplePropertyValueModel();
        this.primaryKeysHaveSameNameValueHolder = this.buildPrimaryKeysHaveSameNameValueHolder();
        this.selectedTableReferenceSelectionHolder = this.buildSelectedTableReferenceHolder();
    }

    protected String getHelpTopicId() {
        return "descriptor.multitable";
    }

    protected Component buildPage() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel primaryTablePanel = this.buildPrimaryTablePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 10, 0);
        mainPanel.add((Component)primaryTablePanel, constraints);
        JComponent multiTableSelectionPanel = this.buildMultiTableSelectionPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)multiTableSelectionPanel, constraints);
        JPanel tableAssociationsPanel = this.buildTableAssociationPanel();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        mainPanel.add((Component)tableAssociationsPanel, constraints);
        this.addHelpTopicId(mainPanel, this.getHelpTopicId());
        return mainPanel;
    }

    private JPanel buildPrimaryTablePanel() {
        JPanel primaryTablePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel tableLabel = this.buildLabel("MULTI_TABLE_INFO_POLICY_PRIMARY_TABLE");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        primaryTablePanel.add((Component)tableLabel, constraints);
        LabelPanel primaryTableLabelPanel = new LabelPanel(this.buildLabelPanelTextAdapter());
        Insets insets = UIManager.getInsets("TextField.margin");
        if (insets == null) {
            insets = UIManager.getInsets("TextField.contentMargins");
        }
        primaryTableLabelPanel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right)));
        Dimension size = tableLabel.getPreferredSize();
        insets = primaryTableLabelPanel.getBorder().getBorderInsets(primaryTableLabelPanel);
        primaryTableLabelPanel.setPreferredSize(new Dimension(1, size.height + insets.top + insets.bottom));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        primaryTablePanel.add((Component)primaryTableLabelPanel, constraints);
        return primaryTablePanel;
    }

    protected PropertyValueModel buildLabelPanelTextAdapter() {
        return new PropertyAspectAdapter(this.getPrimaryTableHolder(), "qualifiedName"){

            protected Object getValueFromSubject() {
                return ((MWTable)this.subject).getName();
            }
        };
    }

    private JComponent buildMultiTableSelectionPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel multiTableSelectionPanel = new JPanel(new GridBagLayout());
        JLabel label = this.buildLabel("MULTI_TABLE_INFO_POLICY_ADDITIONAL_TABLES");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        multiTableSelectionPanel.add((Component)label, constraints);
        AddRemoveListPanel tableAddRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), new TableSelectionAdapter(), this.buildSortedSecondaryTablesAdapter(), 2, this.resourceRepository().getString("MULTI_TABLE_INFO_POLICY_ADDITIONAL_TABLES"), this.buildTableNodeSelector());
        tableAddRemoveListPanel.setCellRenderer(new TableCellRenderer());
        tableAddRemoveListPanel.getList().setSelectionMode(0);
        tableAddRemoveListPanel.addListSelectionListener(new MultiTableListSelectionHandler(tableAddRemoveListPanel, this.selectedSecondaryTableHolder));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        multiTableSelectionPanel.add((Component)tableAddRemoveListPanel, constraints);
        label.setLabelFor(tableAddRemoveListPanel);
        this.buildMultiTableSelectionPanelEnabler(new Component[]{tableAddRemoveListPanel});
        return multiTableSelectionPanel;
    }

    private JPanel buildTableAssociationPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel tableAssociationPanel = new JPanel(new GridBagLayout());
        tableAssociationPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("MULTI_TABLE_INFO_POLICY_ASSOCIATION_TO_PRIMARY"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JRadioButton samePKButton = this.buildPrimaryKeysHaveSameNameButton();
        JPanel referenceChooserPanel = this.buildReferenceSelectionPanel();
        GroupBox.fillVertical(referenceChooserPanel);
        JRadioButton useReferenceButton = this.buildUseReferenceButton();
        GroupBox groupBox = new GroupBox(samePKButton, useReferenceButton, referenceChooserPanel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        tableAssociationPanel.add((Component)groupBox, constraints);
        new ComponentEnabler(this.buildReferencePanelEnabler(), referenceChooserPanel.getComponents());
        new ComponentEnabler(this.buildPrimaryKeyButtonEnabler(), new Component[]{samePKButton, useReferenceButton});
        return tableAssociationPanel;
    }

    private JPanel buildReferenceSelectionPanel() {
        JPanel referenceSelectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel referenceChooserLabel = this.buildLabel("MULTI_TABLE_INFO_POLICY_TABLE_REFERENCE");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        referenceSelectionPanel.add((Component)referenceChooserLabel, constraints);
        this.referenceListChooser = this.buildSelectedTableReferenceListChooser();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        referenceSelectionPanel.add((Component)this.referenceListChooser, constraints);
        referenceChooserLabel.setLabelFor(this.referenceListChooser);
        Spacer spacer = new Spacer();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 5, 0, 0);
        referenceSelectionPanel.add((Component)spacer, constraints);
        this.addAlignRight(spacer);
        ColumnPairsPanel associatonsPanel = new ColumnPairsPanel(this.getWorkbenchContextHolder(), this.selectedTableReferenceSelectionHolder);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        referenceSelectionPanel.add((Component)associatonsPanel, constraints);
        this.addPaneForAlignment(associatonsPanel);
        return referenceSelectionPanel;
    }

    PropertyValueModel getMultiTableInfoPolicyHolder() {
        return this.multiTableInfoPolicyHolder;
    }

    private PropertyValueModel buildMultiTableInfoPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "multiTableInfoPolicy"){

            protected Object getValueFromSubject() {
                MWDescriptorPolicy policy = ((MWTableDescriptor)this.subject).getMultiTableInfoPolicy();
                return policy.isActive() ? policy : null;
            }
        };
    }

    private PropertyValueModel buildPrimaryTableHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "primaryTable"){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getPrimaryTable();
            }
        };
    }

    private PropertyValueModel getPrimaryTableHolder() {
        return this.primaryTableHolder;
    }

    private PropertyValueModel buildPrimaryKeysHaveSameNameValueHolder() {
        return new PropertyAspectAdapter(this.getSelectedSecondaryTableAssocationHolder(), "primaryKeysHaveSameName"){

            protected Object getValueFromSubject() {
                return ((MWSecondaryTableHolder)this.subject).primaryKeysHaveSameName();
            }

            protected void setValueOnSubject(Object value) {
                ((MWSecondaryTableHolder)this.subject).setPrimaryKeysHaveSameName(((Boolean)value).booleanValue());
            }
        };
    }

    private PropertyValueModel getPrimaryKeysHaveSameNameValueHolder() {
        return this.primaryKeysHaveSameNameValueHolder;
    }

    private PropertyValueModel buildSelectedTableReferenceHolder() {
        return new PropertyAspectAdapter(this.selectedSecondaryTableHolder, "reference"){

            protected Object getValueFromSubject() {
                if (((MWSecondaryTableHolder)this.subject).primaryKeysHaveSameName()) {
                    return null;
                }
                return ((MWSecondaryTableHolder)this.subject).getReference();
            }

            protected void setValueOnSubject(Object value) {
                ((MWSecondaryTableHolder)this.subject).setReference((MWReference)value);
            }
        };
    }

    private PropertyValueModel getSelectedSecondaryTableAssocationHolder() {
        return this.selectedSecondaryTableHolder;
    }

    private ListValueModel buildSortedSecondaryTablesAdapter() {
        return new SortedListValueModelAdapter(this.buildSecondaryTableNamesAdapter());
    }

    private ListValueModel buildSecondaryTableNamesAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSecondaryTablesAdapter(), "qualifiedName");
    }

    private ListValueModel buildSecondaryTablesAdapter() {
        return new TransformationListValueModelAdapter(this.buildSecondaryTableHoldersAdapter()){

            protected Object transformItem(Object item) {
                return ((MWSecondaryTableHolder)item).getTable();
            }
        };
    }

    private CollectionValueModel buildSecondaryTableHoldersAdapter() {
        return new CollectionAspectAdapter(this.getMultiTableInfoPolicyHolder(), "secondaryTableHolders"){

            protected Iterator getValueFromSubject() {
                return ((MWDescriptorMultiTableInfoPolicy)this.subject).secondaryTableHolders();
            }
        };
    }

    private NodeSelector buildTableNodeSelector() {
        return new NodeSelector(){

            public void selectNodeFor(Object item) {
                RelationalProjectNode projectNode = (RelationalProjectNode)MultiTableInfoPropertiesPage.this.navigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectTableNodeFor((MWTable)item, MultiTableInfoPropertiesPage.this.navigatorSelectionModel());
            }
        };
    }

    MWTableDescriptor getDescriptor() {
        return (MWTableDescriptor)this.getSelectionHolder().getValue();
    }

    void removeAssociatedTables(Collection associatedTables) {
        Iterator iter = associatedTables.iterator();
        while (iter.hasNext()) {
            this.getDescriptor().removeAssociatedTable((MWTable)iter.next());
        }
    }

    private ListChooser buildSelectedTableReferenceListChooser() {
        ListChooser listChooser = new ListChooser(this.buildSelectedTableReferenceComboboxModel());
        listChooser.setRenderer(this.buildReferenceCellRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildSelectedTableReferenceComboboxModel() {
        return new IndirectComboBoxModel(this.selectedTableReferenceSelectionHolder, this.selectedSecondaryTableHolder){

            protected ListIterator listValueFromSubject(Object subject) {
                return MultiTableInfoPropertiesPage.this.orderedReferenceChoices(((MWSecondaryTableHolder)subject).getTable());
            }
        };
    }

    ListIterator orderedReferenceChoices(MWTable mwTable) {
        return CollectionTools.sort((Iterator)mwTable.referencesBetween((MWTable)this.primaryTableHolder.getValue())).listIterator();
    }

    private ValueModel buildPrimaryKeyButtonEnabler() {
        return new TransformationPropertyValueModel(this.selectedSecondaryTableHolder){

            protected Object transform(Object value) {
                return value != null;
            }
        };
    }

    private ValueModel buildReferencePanelEnabler() {
        return new TransformationPropertyValueModel(this.primaryKeysHaveSameNameValueHolder){

            protected Object transform(Object value) {
                if (value == null) {
                    return Boolean.FALSE;
                }
                return (Boolean)value == false;
            }
        };
    }

    private ComponentEnabler buildMultiTableSelectionPanelEnabler(Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(this.getPrimaryTableHolder()){

            protected Object transform(Object value) {
                return value != null;
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }

    private JRadioButton buildPrimaryKeysHaveSameNameButton() {
        JRadioButton radioButton = this.buildRadioButton("MULTI_TABLE_INFO_POLICY_PRIMARY_KEYS_HAVE", new RadioButtonModelAdapter(this.getPrimaryKeysHaveSameNameValueHolder(), Boolean.TRUE));
        return radioButton;
    }

    private JRadioButton buildUseReferenceButton() {
        JRadioButton radioButton = this.buildRadioButton("MULTI_TABLE_INFO_POLICY_REFERENCE", new RadioButtonModelAdapter(this.getPrimaryKeysHaveSameNameValueHolder(), Boolean.FALSE));
        return radioButton;
    }

    private ListCellRenderer buildReferenceCellRenderer() {
        return new AdaptableListCellRenderer(new ReferenceCellRendererAdapter(this.resourceRepository()));
    }

    DefaultListChooserDialog buildAddTableDialog() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("MULTI_TABLE_INFO_POLICY_ADD_TABLE_DIALOG.title");
        builder.setListBoxLabelKey("MULTI_TABLE_INFO_POLICY_ADD_TABLE_DIALOG.listLabel");
        builder.setHelpTopicId("dialog.selectTable");
        builder.setStringConverter(this.buildTableStringConverter());
        builder.setCompleteList(CollectionTools.array((Iterator)this.buildTables(), (Object[])new MWTable[0]));
        return new DefaultListChooserDialog(this.getWorkbenchContext(), builder);
    }

    private StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return ((MWTable)o).getName();
            }
        };
    }

    private Iterator buildTables() {
        List allTables = CollectionTools.list((Iterator)((MWTableDescriptor)this.selection()).getDatabase().tables());
        if (this.getDescriptor() != null) {
            allTables.removeAll(CollectionTools.list((Iterator)this.getDescriptor().associatedTables()));
        }
        return CollectionTools.sort((List)allTables).listIterator();
    }

    private class MultiTableListSelectionHandler
    implements ListSelectionListener {
        private AddRemoveListPanel listPanel;
        private PropertyValueModel selectionModel;

        private MultiTableListSelectionHandler(AddRemoveListPanel listPanel, PropertyValueModel selectionModel) {
            this.selectionModel = selectionModel;
            this.listPanel = listPanel;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.listPanel.getSelectedValues().length > 1) {
                this.selectionModel.setValue(null);
            } else {
                MWTable selectedTable = (MWTable)this.listPanel.getSelectedValue();
                MWDescriptorMultiTableInfoPolicy multiTablePolicy = (MWDescriptorMultiTableInfoPolicy)MultiTableInfoPropertiesPage.this.getMultiTableInfoPolicyHolder().getValue();
                if (multiTablePolicy != null) {
                    this.selectionModel.setValue(multiTablePolicy.secondaryTableHolderFor(selectedTable));
                } else {
                    this.selectionModel.setValue(null);
                }
            }
        }
    }

    private class TableCellRenderer
    extends SimpleListCellRenderer {
        private TableCellRenderer() {
        }

        protected String buildText(Object value) {
            return ((MWTable)value).getName();
        }
    }

    private class TableSelectionAdapter
    implements AddRemovePanel.Adapter {
        private TableSelectionAdapter() {
        }

        public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            MWTable selection;
            DefaultListChooserDialog dialog = MultiTableInfoPropertiesPage.this.buildAddTableDialog();
            dialog.show();
            if (dialog.wasConfirmed() && (selection = (MWTable)dialog.selection()) != null) {
                MultiTableInfoPropertiesPage.this.getDescriptor().addAssociatedTable(selection);
                listSelectionModel.setSelectedValue(((MWDescriptorMultiTableInfoPolicy)MultiTableInfoPropertiesPage.this.getDescriptor().getMultiTableInfoPolicy()).secondaryTableHolderFor(selection));
            }
        }

        public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            MultiTableInfoPropertiesPage.this.removeAssociatedTables(CollectionTools.collection((Object[])listSelectionModel.getSelectedValues()));
        }
    }
}

