/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public abstract class AbstractLockingPolicyPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel lockingPolicyHolder;
    private PropertyValueModel lockingPolicyTypeHolder;

    public AbstractLockingPolicyPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.lockingPolicyHolder = this.buildLockingPolicyHolder();
        this.lockingPolicyTypeHolder = this.buildLockingPolicyTypeValueHolder();
    }

    private PropertyValueModel buildLockingPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWMappingDescriptor)this.subject).getLockingPolicy();
            }
        };
    }

    private PropertyValueModel buildLockingPolicyTypeValueHolder() {
        return new PropertyAspectAdapter(this.buildLockingPolicyHolder(), "lockingType"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorLockingPolicy)this.subject).getLockingType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorLockingPolicy)this.subject).setLockingType((String)value);
            }
        };
    }

    protected PropertyValueModel getLockingPolicyHolder() {
        return this.lockingPolicyHolder;
    }

    protected PropertyValueModel getLockingPolicyTypeHolder() {
        return this.lockingPolicyTypeHolder;
    }

    protected JRadioButton buildUseNoneButton() {
        return this.buildRadioButton("LOCKING_POLICY_NO_LOCKING", new RadioButtonModelAdapter(this.getLockingPolicyTypeHolder(), "None"));
    }

    protected JRadioButton buildUseOptimisticButton() {
        return this.buildRadioButton("LOCKING_POLICY_OPTIMISTIC_LOCKING", new RadioButtonModelAdapter(this.getLockingPolicyTypeHolder(), "Optimistic Locking"));
    }

    protected JRadioButton buildUsePessimisticButton() {
        return this.buildRadioButton("LOCKING_POLICY_PESSIMISTIC_LOCKING", new RadioButtonModelAdapter(this.getLockingPolicyTypeHolder(), "Pessimistic Locking"));
    }

    protected JPanel buildPessimisticLockingPanel() {
        JPanel pessimisticPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JCheckBox waitForLockCheckbox = this.buildWaitForLockCheckBox();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        pessimisticPanel.add((Component)waitForLockCheckbox, constraints);
        return pessimisticPanel;
    }

    private PropertyValueModel buildTransactionalPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWMappingDescriptor)this.subject).getTransactionalPolicy();
            }
        };
    }

    private JCheckBox buildWaitForLockCheckBox() {
        return this.buildCheckBox("LOCKING_POLICY_WAIT_LOCK", this.buildWaitForLockCheckBoxModel());
    }

    private ButtonModel buildWaitForLockCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildWaitForLockModel());
    }

    private PropertyValueModel buildWaitForLockModel() {
        return new PropertyAspectAdapter(this.getLockingPolicyHolder(), "waitForLock"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorLockingPolicy)this.subject).shouldWaitForLock();
            }

            protected void setValueOnSubject(Object value) {
                ((MWDescriptorLockingPolicy)this.subject).setWaitForLock(((Boolean)value).booleanValue());
            }
        };
    }

    protected ComponentEnabler buildPessimisticLockingPanelEnabler(Component[] components) {
        TransformationPropertyValueModel booleanHolder = new TransformationPropertyValueModel(this.getLockingPolicyTypeHolder()){

            protected Object transform(Object value) {
                return "Pessimistic Locking".equals(value);
            }
        };
        return new ComponentEnabler((ValueModel)booleanHolder, components);
    }

    protected Collection collectComponents(Container parent) {
        Vector<Component> components = new Vector<Component>();
        Component[] children = parent.getComponents();
        for (int i = 0; i < children.length; ++i) {
            components.add(children[i]);
            if (!(children[i] instanceof Container)) continue;
            components.addAll(this.collectComponents((Container)children[i]));
        }
        return components;
    }

    protected Component[] collectComponentsAsArray(Container parent) {
        Collection componentCollection = this.collectComponents(parent);
        return componentCollection.toArray(new Component[componentCollection.size()]);
    }
}

