/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsResourceBundle;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public class FileChooser
extends JFileChooser {
    boolean convertToRelativePath;
    private File rootFile;
    private boolean dialogIsVisible;

    public FileChooser() {
        this((File)null, (File)null);
    }

    public FileChooser(File currentDirectory) {
        this(currentDirectory, (File)null);
    }

    public FileChooser(File currentDirectory, File rootFile) {
        super(currentDirectory);
        this.rootFile = rootFile;
        this.convertToRelativePath = this.rootFile != null;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        if (this.rootFile != null) {
            this.addRelativeCheckBoxTo(dialog.getContentPane());
        }
        return dialog;
    }

    private void addRelativeCheckBoxTo(Container contentPane) {
        DefaultResourceRepository rr = new DefaultResourceRepository(UIToolsResourceBundle.class);
        JCheckBox relativeCheckBox = new JCheckBox(rr.getString("FILECHOOSER_MAKE_RELATIVE_CHECKBOX", this.rootFile.getPath()));
        relativeCheckBox.setSelected(this.convertToRelativePath);
        relativeCheckBox.setMnemonic(rr.getMnemonic("FILECHOOSER_MAKE_RELATIVE_CHECKBOX"));
        relativeCheckBox.setDisplayedMnemonicIndex(rr.getMnemonicIndex("FILECHOOSER_MAKE_RELATIVE_CHECKBOX"));
        relativeCheckBox.addActionListener(this.buildActionListener());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        panel.add((Component)relativeCheckBox, "Before");
        contentPane.add((Component)panel, "Last");
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileChooser.this.convertToRelativePath = ((JCheckBox)e.getSource()).isSelected();
            }
        };
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        this.dialogIsVisible = true;
        int result = super.showDialog(parent, approveButtonText);
        this.dialogIsVisible = false;
        return result;
    }

    public File getSelectedFile() {
        File selectedFile = super.getSelectedFile();
        selectedFile = this.checkForDuplicateEntry(selectedFile);
        return this.convertToRelativeFile(selectedFile);
    }

    public File[] getSelectedFiles() {
        File[] files = super.getSelectedFiles();
        if (files.length == 1) {
            files[0] = this.checkForDuplicateEntry(files[0]);
        }
        return this.convertToRelativeFiles(files);
    }

    private File checkForDuplicateEntry(File file) {
        if (this.getFileSelectionMode() == 2 || this.getFileSelectionMode() == 1) {
            File currentDirectory = this.getCurrentDirectory();
            if (file != null && file.isAbsolute() && !file.exists()) {
                file = currentDirectory;
            }
        }
        return file;
    }

    public void setSelectedFile(File file) {
        super.setSelectedFile(this.convertToAbsoluteFile(file));
    }

    public void setSelectedFiles(File[] files) {
        super.setSelectedFiles(this.convertToAbsoluteFiles(files));
    }

    private File[] convertToRelativeFiles(File[] files) {
        int i = files.length;
        while (i-- > 0) {
            files[i] = this.convertToRelativeFile(files[i]);
        }
        return files;
    }

    private File convertToRelativeFile(File file) {
        if (this.dialogIsVisible) {
            return file;
        }
        if (file == null) {
            return file;
        }
        if (this.convertToRelativePath) {
            file = new File(file.getPath());
            return FileTools.convertToRelativeFile((File)file, (File)this.rootFile);
        }
        return file;
    }

    private File[] convertToAbsoluteFiles(File[] files) {
        if (files == null) {
            return files;
        }
        int i = files.length;
        while (i-- > 0) {
            files[i] = this.convertToAbsoluteFile(files[i]);
        }
        return files;
    }

    private File convertToAbsoluteFile(File file) {
        if (this.dialogIsVisible) {
            return file;
        }
        if (file == null) {
            return file;
        }
        if (this.convertToRelativePath) {
            return FileTools.convertToAbsoluteFile((File)file, (File)this.rootFile);
        }
        return file;
    }
}

