/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;

public class AddRemoveTablePanel
extends AddRemovePanel {
    private JTable table;

    public AddRemoveTablePanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, ColumnAdapter columnModel) {
        this(context, adapter, listModel, columnModel, 2);
    }

    public AddRemoveTablePanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, ColumnAdapter columnModel, int buttonOrientation) {
        this(context, adapter, listModel, columnModel, buttonOrientation, null, new NodeSelector.DefaultNodeSelector());
    }

    public AddRemoveTablePanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, ColumnAdapter columnModel, int buttonOrientation, NodeSelector nodeSelector) {
        this(context, adapter, listModel, columnModel, buttonOrientation, null, nodeSelector);
    }

    public AddRemoveTablePanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, ColumnAdapter columnModel, int buttonOrientation, String initialAccessName, NodeSelector nodeSelector) {
        super(context, adapter, listModel, buttonOrientation, nodeSelector);
        this.initialize(listModel, columnModel);
        this.initializeLayout(initialAccessName);
    }

    public AddRemoveTablePanel(ApplicationContext context, AddRemovePanel.Adapter adapter, ListValueModel listModel, ColumnAdapter columnModel, String initialAccessName) {
        this(context, adapter, listModel, columnModel, 2, initialAccessName, new NodeSelector.DefaultNodeSelector());
    }

    protected void initialize(ListValueModel listModel, ColumnAdapter columnModel) {
        this.table = SwingComponentFactory.buildTable(new TableModelAdapter(listModel, columnModel), this.getSelectionModel());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addKeyListener(this.buildF3KeyListener());
    }

    protected void initializeLayout(String accessibleName) {
        this.initializeButtonPanel();
        this.initializeTablePanel(accessibleName);
    }

    protected void initializeTablePanel(String accessibleName) {
        GridBagConstraints constraints = new GridBagConstraints();
        if (this.getButtonOrientation() == 1) {
            constraints.gridx = 0;
            constraints.gridy = 1;
        } else if (this.getButtonOrientation() == 4) {
            constraints.gridx = 1;
            constraints.gridy = 0;
        } else {
            constraints.gridx = 0;
            constraints.gridy = 0;
        }
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.table.getAccessibleContext().setAccessibleName(accessibleName);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setMinimumSize(new Dimension(1, 1));
        scrollPane.setPreferredSize(new Dimension(1, 1));
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)scrollPane, constraints);
    }

    public JComponent getComponent() {
        return this.table;
    }

    protected void moveItemsDown() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.moveItemsDown();
    }

    protected void moveItemsUp() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.moveItemsUp();
    }

    protected void addNewItem() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.addNewItem();
    }

    protected void removeSelectedItems() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.removeSelectedItems();
    }
}

