/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class TextAreaDialog
extends AbstractDialog {
    private String text;
    private String helpTopicID;
    private JTextArea textArea;

    private static String buildStackTrace(Throwable exception) {
        StringWriter stream = new StringWriter(5000);
        exception.printStackTrace(new PrintWriter(stream));
        return ((Object)stream).toString();
    }

    public TextAreaDialog(String text, String title, String helpTopicID, WorkbenchContext context) {
        super(context, title);
        this.text = text;
        this.helpTopicID = helpTopicID;
    }

    public TextAreaDialog(String text, String helpTopicID, WorkbenchContext context) {
        super(context);
        this.text = text;
        this.helpTopicID = helpTopicID;
    }

    public TextAreaDialog(String text, String helpTopicID, WorkbenchContext context, Dialog owner) {
        super(context, owner);
        this.text = text;
        this.helpTopicID = helpTopicID;
    }

    public TextAreaDialog(Throwable exception, String helpTopicID, WorkbenchContext context) {
        this(TextAreaDialog.buildStackTrace(exception), helpTopicID, context);
    }

    public TextAreaDialog(Throwable exception, String helpTopicID, WorkbenchContext context, Dialog owner) {
        this(TextAreaDialog.buildStackTrace(exception), helpTopicID, context, owner);
    }

    protected String helpTopicId() {
        return this.helpTopicID;
    }

    protected Component buildMainPanel() {
        this.setSize(500, 400);
        this.textArea = this.buildTextArea();
        return new JScrollPane(this.textArea);
    }

    protected JTextArea buildTextArea() {
        JTextArea result = new JTextArea(this.text);
        result.setFont(UIManager.getFont("Label.font"));
        result.setEditable(false);
        return result;
    }

    protected boolean cancelButtonIsVisible() {
        return false;
    }

    protected Iterator buildCustomActions() {
        Action copyAction = this.buildCopyAction();
        return new SingleElementIterator((Object)copyAction);
    }

    private Action buildCopyAction() {
        return new AbstractAction(this.buildCopyText()){

            public void actionPerformed(ActionEvent e) {
                TextAreaDialog.this.copyPressed();
            }
        };
    }

    protected String buildCopyText() {
        return this.resourceRepository().getString("TEXT_AREA_DIALOG.COPY_BUTTON_TEXT");
    }

    protected void copyPressed() {
        int pos = this.textArea.getCaretPosition();
        this.textArea.selectAll();
        this.textArea.copy();
        this.textArea.setCaretPosition(pos);
    }

    protected void prepareToShow() {
        this.setLocationRelativeTo(this.getParent());
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }
}

