/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class SaveModifiedProjectsDialog
extends AbstractDialog {
    private Collection dirtyNodes;
    private ObjectListSelectionModel selectionModel;
    private CheckList checkList;
    private Action selectAllAction;
    private Action unselectAllAction;

    SaveModifiedProjectsDialog(WorkbenchContext context, Collection dirtyNodes) {
        this(context, dirtyNodes, new ArrayList(dirtyNodes));
    }

    SaveModifiedProjectsDialog(WorkbenchContext context, Collection dirtyNodes, Collection initialSelection) {
        super(context);
        this.initialize(dirtyNodes, initialSelection);
    }

    protected void initialize() {
        super.initialize();
        this.setName("File.SaveAll");
        this.setTitle(this.resourceRepository().getString("saveModifiedDocuments.title"));
    }

    private void initialize(Collection dirtyNodes, Collection initialSelection) {
        this.dirtyNodes = dirtyNodes;
        ReadOnlyCollectionValueModel dirtyNodesHolder = new ReadOnlyCollectionValueModel(dirtyNodes);
        this.selectionModel = new ObjectListSelectionModel(new ListModelAdapter(dirtyNodesHolder));
        this.checkList = new CheckList(dirtyNodesHolder, (ListSelectionModel)this.selectionModel, this.buildCellRendererAdapter());
        this.selectionModel.setSelectedValues(dirtyNodes);
    }

    private CellRendererAdapter buildCellRendererAdapter() {
        return new AbstractCellRendererAdapter(){

            public String buildAccessibleName(Object value) {
                ApplicationNode node = (ApplicationNode)value;
                String accessibleName = node.accessibleName();
                File saveLocation = node.saveFile();
                if (accessibleName != null && saveLocation != null && !saveLocation.toString().equals(node.displayString())) {
                    accessibleName = accessibleName + " [" + saveLocation + "]";
                }
                return accessibleName;
            }

            public Icon buildIcon(Object value) {
                return ((Displayable)value).icon();
            }

            public String buildText(Object value) {
                ApplicationNode node = (ApplicationNode)value;
                String display = node.displayString();
                File saveLocation = node.saveFile();
                if (saveLocation != null && !saveLocation.toString().equals(display)) {
                    display = display + " [" + saveLocation + "]";
                }
                return display;
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setPreferredSize(new Dimension(405, 250));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel label = new JLabel(this.resourceRepository().getString("saveModifiedDocuments.message"));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic("saveModifiedDocuments.message"));
        label.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("saveModifiedDocuments.message"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 5, 0);
        mainPanel.add((Component)label, constraints);
        label.setLabelFor(this.checkList);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)this.checkList, constraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 0, 5, 0);
        mainPanel.add((Component)buttonPanel, constraints);
        this.selectAllAction = this.buildSelectAllAction();
        JButton selectAllButton = new JButton(this.selectAllAction);
        selectAllButton.setText(this.resourceRepository().getString("selectAll"));
        selectAllButton.setMnemonic(this.resourceRepository().getMnemonic("selectAll"));
        selectAllButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("selectAll"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 0);
        buttonPanel.add((Component)selectAllButton, constraints);
        this.unselectAllAction = this.buildUnselectAllAction();
        JButton unselectAllButton = new JButton(this.unselectAllAction);
        unselectAllButton.setText(this.resourceRepository().getString("deselectAll"));
        unselectAllButton.setMnemonic(this.resourceRepository().getMnemonic("deselectAll"));
        unselectAllButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("deselectAll"));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 0, 0);
        buttonPanel.add((Component)unselectAllButton, constraints);
        return mainPanel;
    }

    protected String helpTopicId() {
        return "dialog.file.saveAll";
    }

    protected Component initialFocusComponent() {
        return this.checkList;
    }

    private Action buildSelectAllAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SaveModifiedProjectsDialog.this.selectAllPressed();
            }
        };
    }

    private void selectAllPressed() {
        this.selectionModel.setSelectionInterval(0, this.dirtyNodes.size() - 1);
    }

    private Action buildUnselectAllAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SaveModifiedProjectsDialog.this.unselectAllPressed();
            }
        };
    }

    private void unselectAllPressed() {
        this.selectionModel.clearSelection();
    }

    Collection selectedNodes() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        return Arrays.asList(this.selectionModel.getSelectedValues());
    }
}

