/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.DefaultHelpManager;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManagerConfig;
import org.eclipse.persistence.tools.workbench.framework.help.HelpPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.help.HelpTopicIDWindowAction;
import org.eclipse.persistence.tools.workbench.framework.help.InternalHelpManager;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class HelpFacade {
    private static final String HELP_PREFERENCES_NODE = "help";
    private static final String HELP_SET_FILE_NAME = "/tlmwhelp.hs";
    private static final String HELP_JAR_NAME = "/tlmwhelp.jar";
    private static final String BASE_HELP_JAR_NAME = "/tlmwhelp";
    static final String LOCAL_FILE_PREFERENCE = "local file";
    static final String LOCAL_FILE_PREFERENCE_DEFAULT = "";
    static final String DISPLAY_WELCOME_PREFERENCE = "display welcome";
    static final boolean DISPLAY_WELCOME_PREFERENCE_DEFAULT = true;

    public static HelpManager buildHelpManager(HelpManagerConfig config) {
        Preferences helpPreferences = config.getPreferences().node(HELP_PREFERENCES_NODE);
        return new DefaultHelpManager(config.getResourceRepository(), helpPreferences);
    }

    private static URL buildLocalizedHelpUrl(Logger logger) {
        URL helpUrl = HelpFacade.class.getResource(HelpFacade.localizedHelpResourceJarName(true));
        if (helpUrl == null) {
            helpUrl = HelpFacade.class.getResource(HelpFacade.localizedHelpResourceJarName(false));
        }
        if (helpUrl != null) {
            try {
                helpUrl = new URL("jar:" + helpUrl.toString() + "!/");
            }
            catch (MalformedURLException ex) {
                HelpFacade.log(logger, "LOCALIZED_FILE_NOT_FOUND", helpUrl, ex);
            }
            URL[] urls = new URL[]{helpUrl};
            URLClassLoader cl = new URLClassLoader(urls);
            helpUrl = cl.findResource(HELP_SET_FILE_NAME);
        }
        return helpUrl;
    }

    private static String localizedHelpResourceJarName(boolean includeCountryCode) {
        Locale locale = Locale.getDefault();
        StringBuffer sb = new StringBuffer();
        sb.append(BASE_HELP_JAR_NAME);
        sb.append("_");
        sb.append(locale.getLanguage());
        if (includeCountryCode && !StringTools.stringIsEmpty((String)locale.getCountry())) {
            sb.append("_");
            sb.append(locale.getCountry());
        }
        sb.append(".jar");
        return sb.toString();
    }

    private static void startPostLaunchThread(InternalHelpManager helpManager, HelpManagerConfig config) {
        new Thread(HelpFacade.buildPostLaunchRunnable(helpManager, config), "Display Welcome").start();
    }

    private static Runnable buildPostLaunchRunnable(final InternalHelpManager helpManager, final HelpManagerConfig config) {
        return new Runnable(){

            public void run() {
                try {
                    config.getLaunchCompleteFlag().waitUntilTrue();
                }
                catch (InterruptedException ex) {
                    return;
                }
                Preferences helpPreferences = config.getPreferences().node(HelpFacade.HELP_PREFERENCES_NODE);
                if (config.forceStupidWelcomeScreen() || helpPreferences.getBoolean(HelpFacade.DISPLAY_WELCOME_PREFERENCE, true)) {
                    helpManager.showTopic("welcome");
                }
                helpManager.launchComplete();
            }
        };
    }

    private static void log(Logger logger, String message, Object parm, Throwable exception) {
        LogRecord logRecord = new LogRecord(Level.WARNING, message);
        logRecord.setParameters(new Object[]{parm});
        logRecord.setThrown(exception);
        logRecord.setLoggerName(logger.getName());
        logRecord.setResourceBundle(logger.getResourceBundle());
        logger.log(logRecord);
    }

    public static FrameworkAction buildHelpTopicIDWindowAction(WorkbenchContext context) {
        return new HelpTopicIDWindowAction(context);
    }

    public static PreferencesNode buildHelpPreferencesNode(PreferencesContext context) {
        PreferencesContext helpContext = (PreferencesContext)context.buildRedirectedPreferencesContext(HELP_PREFERENCES_NODE);
        return new HelpPreferencesNode(helpContext);
    }

    private HelpFacade() {
        throw new UnsupportedOperationException();
    }

    private static class LocalHelpBookWarning
    extends RuntimeException {
        LocalHelpBookWarning() {
        }
    }
}

