/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.tools.workbench.ant.SessionValidatorInterface;
import org.eclipse.persistence.tools.workbench.ant.taskdefs.TopLinkTask;
import org.eclipse.persistence.tools.workbench.ant.typedefs.LoginSpec;

public class SessionValidateTask
extends TopLinkTask
implements SessionValidatorInterface {
    private String property;
    private LoginSpec loginSpec;

    protected void initialize() {
        super.initialize();
        this.property = null;
        this.loginSpec = null;
    }

    public void addLoginSpec(LoginSpec loginSpec) {
        this.loginSpec = loginSpec;
    }

    public void execute() throws BuildException {
        super.execute();
        int status = this.execute(this.getSessionName(), this.getSessionsFile(), this.getUrl(), this.getDriverClass(), this.getUser(), this.getPassword());
        if (status == 0 && this.property != null) {
            this.getProject().setNewProperty(this.property, "true");
        }
    }

    public int execute(String sessionName, String sessionsFileName, String url, String driverclass, String user, String password) {
        Object[] args = new Object[]{sessionName, sessionsFileName, url, driverclass, user, password};
        return this.execute(args);
    }

    protected String getProjectRunnerClassName() {
        return "org.eclipse.persistence.tools.workbench.ant.SessionValidator";
    }

    protected DatabaseLogin buildLogin() {
        DatabaseLogin login = null;
        if (this.loginSpec != null) {
            login = new DatabaseLogin();
            String url = this.loginSpec.getUrl(this.getProject());
            String driverclass = this.loginSpec.getDriverClass(this.getProject());
            String user = this.loginSpec.getUser(this.getProject());
            String password = this.loginSpec.getPassword(this.getProject());
            if (url != "") {
                login.setDatabaseURL(url);
            }
            if (driverclass != "") {
                login.setDriverClassName(driverclass);
            }
            if (user != "") {
                login.setUserName(user);
            }
            if (password != "") {
                login.setPassword(password);
            }
        }
        return login;
    }

    protected void preExecute() throws BuildException {
        super.preExecute();
        if (this.loginSpec != null && this.loginSpec.getUrl(this.getProject()).length() == 0) {
            throw new BuildException(this.stringRepository.getString("notDefined", "LoginSpec Datasource URL"));
        }
    }

    protected String getUrl() {
        return this.loginSpec == null ? "" : this.loginSpec.getUrl(this.getProject());
    }

    protected String getDriverClass() {
        return this.loginSpec == null ? "" : this.loginSpec.getDriverClass(this.getProject());
    }

    protected String getUser() {
        return this.loginSpec == null ? "" : this.loginSpec.getUser(this.getProject());
    }

    protected String getPassword() {
        return this.loginSpec == null ? "" : this.loginSpec.getPassword(this.getProject());
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

