/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.rest.client;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.RemoteServiceID;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameterSerializer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteServiceClientContainerAdapter;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistry;
import org.eclipse.ecf.remoteservice.client.StringParameterSerializer;
import org.eclipse.ecf.remoteservice.rest.client.RestClientService;
import org.eclipse.ecf.remoteservice.rest.client.XMLRemoteResponseDeserializer;
import org.eclipse.ecf.remoteservice.rest.identity.RestID;
import org.eclipse.ecf.remoteservice.util.RemoteFilterImpl;
import org.osgi.framework.InvalidSyntaxException;

public class RestClientContainer
extends AbstractClientContainer
implements IRemoteServiceClientContainerAdapter {
    public RestClientContainer(RestID id) {
        super((ID)id);
        this.setParameterSerializer((IRemoteCallParameterSerializer)new StringParameterSerializer());
        this.setResponseDeserializer(new XMLRemoteResponseDeserializer());
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return super.getRemoteServiceReferences(this.transformTarget(target, filter), idFilter, clazz, filter);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return super.getRemoteServiceReferences(this.transformTarget(target, filter), clazz, filter);
    }

    protected ID transformTarget(ID originalTarget, String filter) throws InvalidSyntaxException {
        if (originalTarget != null && filter != null && originalTarget instanceof RestID) {
            ((RestID)originalTarget).setRsId(new RemoteFilterImpl(filter).getRsId());
        }
        return originalTarget;
    }

    protected RemoteServiceClientRegistration createRestServiceRegistration(String[] clazzes, IRemoteCallable[][] callables, Dictionary properties) {
        return new RestRemoteServiceClientRegistration(this.getRemoteServiceNamespace(), clazzes, callables, properties, this.registry);
    }

    protected RemoteServiceClientRegistration createRestServiceRegistration(IRemoteCallable[] callables, Dictionary properties) {
        return new RestRemoteServiceClientRegistration(this.getRemoteServiceNamespace(), callables, properties, this.registry);
    }

    protected IRemoteService createRemoteService(RemoteServiceClientRegistration registration) {
        return new RestClientService(this, registration);
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.rest.namespace");
    }

    public String prepareEndpointAddress(IRemoteCall call, IRemoteCallable callable) {
        String resourcePath = callable.getResourcePath();
        if (resourcePath == null || "".equals(resourcePath)) {
            return null;
        }
        if (resourcePath.startsWith("http://")) {
            return resourcePath;
        }
        RestID targetContainerID = (RestID)this.getRemoteCallTargetID();
        String baseUriString = targetContainerID.toURI().toString();
        int length = baseUriString.length();
        char[] lastChar = new char[1];
        baseUriString.getChars(length - 1, length, lastChar, 0);
        char[] firstMethodChar = new char[1];
        resourcePath.getChars(0, 1, firstMethodChar, 0);
        if (lastChar[0] == '/' && firstMethodChar[0] != '/' || lastChar[0] != '/' && firstMethodChar[0] == '/') {
            return String.valueOf(baseUriString) + resourcePath;
        }
        if (lastChar[0] == '/' && firstMethodChar[0] == '/') {
            String tempurl = baseUriString.substring(0, length - 1);
            return String.valueOf(tempurl) + resourcePath;
        }
        if (lastChar[0] != '/' && firstMethodChar[0] != '/') {
            return String.valueOf(baseUriString) + "/" + resourcePath;
        }
        return null;
    }

    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        return false;
    }

    protected class RestRemoteServiceClientRegistration
    extends RemoteServiceClientRegistration {
        public RestRemoteServiceClientRegistration(Namespace namespace, IRemoteCallable[] restCalls, Dictionary properties, RemoteServiceClientRegistry registry) {
            super(namespace, restCalls, properties, registry);
            ID cID = RestClientContainer.this.getConnectedID();
            if (cID != null) {
                this.containerId = cID;
            }
            long rsId = ((RestID)this.containerId).getRsId();
            this.serviceID = new RemoteServiceID(namespace, this.containerId, rsId);
            if (rsId > 0L) {
                if (this.properties == null) {
                    this.properties = new Hashtable();
                }
                this.properties.put("ecf.rsvc.id", new Long(rsId));
            }
        }

        public RestRemoteServiceClientRegistration(Namespace namespace, String[] classNames, IRemoteCallable[][] restCalls, Dictionary properties, RemoteServiceClientRegistry registry) {
            super(namespace, classNames, restCalls, properties, registry);
            ID cID = RestClientContainer.this.getConnectedID();
            if (cID != null) {
                this.containerId = cID;
            }
            long rsId = ((RestID)this.containerId).getRsId();
            this.serviceID = new RemoteServiceID(namespace, this.containerId, rsId);
            if (rsId > 0L) {
                if (this.properties == null) {
                    this.properties = new Hashtable();
                }
                this.properties.put("ecf.rsvc.id", new Long(rsId));
            }
        }
    }
}

