/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.comm.tcp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.util.SimpleFIFOQueue;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IConnectionListener;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.comm.tcp.AsynchMessage;
import org.eclipse.ecf.provider.comm.tcp.ConnectRequestMessage;
import org.eclipse.ecf.provider.comm.tcp.ConnectResultMessage;
import org.eclipse.ecf.provider.comm.tcp.PingMessage;
import org.eclipse.ecf.provider.comm.tcp.PingResponseMessage;
import org.eclipse.ecf.provider.comm.tcp.SocketFactory;
import org.eclipse.ecf.provider.comm.tcp.SynchMessage;

public final class Client
implements ISynchAsynchConnection {
    public static final String PROTOCOL = "ecftcp";
    public static final int DEFAULT_SNDR_PRIORITY = 5;
    public static final int DEFAULT_RCVR_PRIORITY = 5;
    public static final long DEFAULT_CLOSE_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.comm.tcp.client.closetimeout", "2000"));
    public static final int DEFAULT_MAX_BUFFER_MSG = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.comm.tcp.client.maxmsgs", "50"));
    public static final int DEFAULT_WAIT_INTERVAL = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.comm.tcp.client.waitinterval", "10"));
    protected Socket socket;
    private String addressPort = "-1:<no endpoint>:-1";
    protected ObjectOutputStream outputStream;
    protected ObjectInputStream inputStream;
    protected ISynchAsynchEventHandler handler;
    protected SimpleFIFOQueue queue = new SimpleFIFOQueue();
    protected int keepAlive = 0;
    protected Thread sendThread;
    protected Thread rcvThread;
    protected Thread keepAliveThread;
    protected boolean isClosing = false;
    protected boolean waitForPing = false;
    protected PingMessage ping = new PingMessage();
    protected PingResponseMessage pingResp = new PingResponseMessage();
    protected long closeTimeout = DEFAULT_CLOSE_TIMEOUT;
    protected Map properties;
    protected ID containerID = null;
    protected Object pingLock = new Object();
    boolean disconnectHandled = false;
    private final Object disconnectLock = new Object();
    protected final Object outputStreamLock = new Object();
    private int maxmsgs = DEFAULT_MAX_BUFFER_MSG;
    private int resetCounter = 0;

    private String getHostNameForAddressWithoutLookup(InetAddress inetAddress) {
        String inetAddressStr = inetAddress.toString();
        int slashPos = inetAddressStr.indexOf(47);
        if (slashPos == 0) {
            return inetAddressStr.substring(1);
        }
        return inetAddressStr.substring(0, slashPos);
    }

    private void setSocket(Socket s) throws SocketException {
        this.socket = s;
        this.addressPort = s != null ? String.valueOf(s.getLocalPort()) + ":" + this.getHostNameForAddressWithoutLookup(s.getInetAddress()) + ":" + s.getPort() : "-1:<no endpoint>:-1";
    }

    public Client(Socket aSocket, ObjectInputStream iStream, ObjectOutputStream oStream, ISynchAsynchEventHandler handler) throws IOException {
        this(aSocket, iStream, oStream, handler, DEFAULT_MAX_BUFFER_MSG);
    }

    public Client(Socket aSocket, ObjectInputStream iStream, ObjectOutputStream oStream, ISynchAsynchEventHandler handler, int maxmsgs) throws IOException {
        Assert.isNotNull((Object)aSocket);
        this.keepAlive = Integer.valueOf(System.getProperty("org.eclipse.ecf.provider.generic.keepalive", "30000"));
        if (this.keepAlive > 0) {
            aSocket.setSoTimeout(this.keepAlive);
        }
        this.setSocket(aSocket);
        this.inputStream = iStream;
        this.outputStream = oStream;
        this.handler = handler;
        this.containerID = handler.getEventHandlerID();
        this.properties = new Properties();
        this.maxmsgs = maxmsgs;
        this.setupThreads();
    }

    public Client(ISynchAsynchEventHandler handler, int keepAlive) {
        if (handler == null) {
            throw new NullPointerException("event handler cannot be null");
        }
        this.handler = handler;
        this.keepAlive = keepAlive;
        this.containerID = handler.getEventHandlerID();
        this.properties = new HashMap();
    }

    public synchronized ID getLocalID() {
        if (this.containerID != null) {
            return this.containerID;
        }
        if (this.socket == null) {
            return null;
        }
        ID retID = null;
        try {
            retID = IDFactory.getDefault().createStringID("ecftcp://" + this.getHostNameForAddressWithoutLookup(this.socket.getLocalAddress()) + ":" + this.socket.getLocalPort());
        }
        catch (Exception e) {
            this.traceStack("Exception in getLocalID()", e);
            return null;
        }
        return retID;
    }

    public void removeListener(IConnectionListener l) {
    }

    public void addListener(IConnectionListener l) {
    }

    public synchronized boolean isConnected() {
        if (this.socket != null) {
            return this.socket.isConnected();
        }
        return false;
    }

    public synchronized boolean isStarted() {
        if (this.sendThread != null) {
            return this.sendThread.isAlive();
        }
        return false;
    }

    private void setSocketOptions(Socket aSocket) throws SocketException {
        aSocket.setTcpNoDelay(true);
        if (this.keepAlive > 0) {
            aSocket.setKeepAlive(true);
            aSocket.setSoTimeout(this.keepAlive);
        }
    }

    protected Socket createConnectSocket(URI remote, int timeout) throws ECFException {
        SocketFactory fact = SocketFactory.getSocketFactory();
        if (fact == null) {
            fact = SocketFactory.getDefaultSocketFactory();
        }
        try {
            return fact.createSocket(remote.getHost(), remote.getPort(), timeout);
        }
        catch (IOException e) {
            throw new ECFException("Could not create socket to connect to id=" + remote, (Throwable)e);
        }
    }

    protected URI parseRemoteID(ID remote) throws ECFException {
        try {
            return new URI(remote.getName());
        }
        catch (URISyntaxException e) {
            throw new ECFException("Invalid URI for remoteID=" + remote, (Throwable)e);
        }
    }

    public synchronized Object connect(ID remote, Object data, int timeout) throws ECFException {
        this.debug("connect(" + remote + "," + data + "," + timeout + ")");
        if (this.socket != null) {
            throw new ECFException("Already connected");
        }
        if (remote == null) {
            throw new ECFException("remote cannot be null");
        }
        URI anURI = this.parseRemoteID(remote);
        Socket s = this.createConnectSocket(anURI, timeout);
        ConnectResultMessage res = null;
        try {
            this.setSocketOptions(s);
            this.setSocket(s);
            this.outputStream = new ObjectOutputStream(s.getOutputStream());
            this.outputStream.flush();
            this.inputStream = ProviderPlugin.getDefault().createObjectInputStream(s.getInputStream());
            this.debug("connect;" + anURI);
            this.send(new ConnectRequestMessage(anURI, (Serializable)data));
            res = (ConnectResultMessage)this.readObject();
        }
        catch (IOException e) {
            throw new ECFException("Exception during connection to " + remote.getName(), (Throwable)e);
        }
        this.debug("connect;rcv:" + res);
        if (res == null) {
            throw new ECFException("Result cannot be null");
        }
        this.setupThreads();
        Serializable ret = res.getData();
        this.debug("connect;returning:" + ret);
        return ret;
    }

    private void setupThreads() {
        this.debug("setupThreads()");
        this.sendThread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Client.this.getSendThread();
            }
        });
        this.rcvThread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Client.this.getRcvThread();
            }
        });
    }

    Thread getSendThread() {
        Thread aThread = new Thread(new Runnable(){

            public void run() {
                Thread me = Thread.currentThread();
                while (!me.isInterrupted()) {
                    Serializable aMsg = (Serializable)Client.this.queue.peekQueue();
                    if (me.isInterrupted() || aMsg == null) break;
                    try {
                        Client.this.send(aMsg);
                        Client.this.queue.removeHead();
                    }
                    catch (Exception e) {
                        Client.this.handleException(e);
                        break;
                    }
                }
                Client.this.handleException(null);
                Client.this.debug("SENDER TERMINATING");
            }
        }, this.getLocalID() + ":sndr:" + this.getAddressPort());
        aThread.setPriority(5);
        return aThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable e) {
        Object object = this.disconnectLock;
        synchronized (object) {
            if (!this.disconnectHandled) {
                this.disconnectHandled = true;
                if (e != null) {
                    this.traceStack("handleException in thread=" + Thread.currentThread().getName(), e);
                }
                this.handler.handleDisconnectEvent(new DisconnectEvent(this, e, this.queue));
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.setSocket(null);
            }
        }
        catch (IOException e) {
            this.traceStack("closeSocket Exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Serializable snd) throws IOException {
        Object object = this.outputStreamLock;
        synchronized (object) {
            this.outputStream.writeObject(snd);
            this.outputStream.flush();
            if (this.resetCounter > this.maxmsgs) {
                this.outputStream.reset();
                this.resetCounter = 0;
            } else {
                ++this.resetCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePingResp() {
        Object object = this.pingLock;
        synchronized (object) {
            this.waitForPing = false;
        }
    }

    public void setCloseTimeout(long t) {
        this.closeTimeout = t;
    }

    private void sendClose(Serializable snd) throws IOException {
        this.isClosing = true;
        this.debug("sendClose(" + snd + ")");
        this.send(snd);
        int interval = DEFAULT_WAIT_INTERVAL;
        for (int count = 0; !this.disconnectHandled && count < interval; ++count) {
            try {
                this.wait(this.closeTimeout / (long)interval);
                continue;
            }
            catch (InterruptedException e) {
                this.traceStack("sendClose wait", e);
                return;
            }
        }
    }

    Thread getRcvThread() {
        Thread aThread = new Thread(new Runnable(){

            public void run() {
                Thread me = Thread.currentThread();
                while (!me.isInterrupted()) {
                    try {
                        Client.this.handleRcv(Client.this.readObject());
                    }
                    catch (Exception e) {
                        Client.this.handleException(e);
                        break;
                    }
                }
                Client.this.handleException(null);
                Client.this.debug("RCVR TERMINATING");
            }
        }, this.getLocalID() + ":rcvr:" + this.getAddressPort());
        aThread.setPriority(5);
        return aThread;
    }

    void handleRcv(Serializable rcv) throws IOException {
        block6: {
            try {
                if (rcv instanceof SynchMessage) {
                    this.handler.handleSynchEvent(new SynchEvent(this, (Object)((SynchMessage)rcv).getData()));
                    break block6;
                }
                if (rcv instanceof AsynchMessage) {
                    Serializable d = ((AsynchMessage)rcv).getData();
                    this.handler.handleAsynchEvent(new AsynchEvent(this, (Object)d));
                    break block6;
                }
                if (rcv instanceof PingMessage) {
                    this.send(this.pingResp);
                    break block6;
                }
                if (rcv instanceof PingResponseMessage) {
                    this.handlePingResp();
                    break block6;
                }
                throw new IOException("Invalid message received");
            }
            catch (IOException e) {
                this.disconnect();
                throw e;
            }
        }
    }

    public synchronized void start() {
        this.debug("start()");
        if (this.sendThread != null) {
            this.sendThread.start();
        }
        if (this.rcvThread != null) {
            this.rcvThread.start();
        }
        if (this.keepAlive > 0) {
            this.keepAliveThread = this.setupPing();
        }
        if (this.keepAliveThread != null) {
            this.keepAliveThread.start();
        }
    }

    public void stop() {
        this.debug("stop()");
    }

    private Thread setupPing() {
        this.debug("setupPing()");
        final int pingStartWait = new Random().nextInt(this.keepAlive / 2);
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread me = Thread.currentThread();
                try {
                    Thread.sleep(pingStartWait);
                }
                catch (InterruptedException e) {
                    return;
                }
                int frequency = Client.this.keepAlive / 2;
                while (!Client.this.queue.isStopped()) {
                    try {
                        if (me.isInterrupted() || Client.this.disconnectHandled) break;
                        Thread.sleep(frequency);
                        if (me.isInterrupted() || Client.this.disconnectHandled) break;
                        Object object = Client.this.pingLock;
                        synchronized (object) {
                            Client.this.waitForPing = true;
                            Client.this.queue.enqueue((Object)Client.this.ping);
                            int count = 0;
                            int interval = DEFAULT_WAIT_INTERVAL;
                            while (Client.this.waitForPing && count < interval) {
                                Client.this.pingLock.wait(frequency / interval);
                                ++count;
                            }
                            if (Client.this.waitForPing) {
                                throw new IOException(String.valueOf(Client.this.getAddressPort()) + " remote not reachable by ping");
                            }
                        }
                    }
                    catch (Exception e) {
                        Client.this.handleException(e);
                        break;
                    }
                }
                Client.this.handleException(null);
                Client.this.debug("PING TERMINATING");
            }
        }, this.getLocalID() + ":ping:" + this.getAddressPort());
    }

    public synchronized void disconnect() {
        this.debug("disconnect()");
        this.queue.close();
        this.closeSocket();
        if (this.keepAliveThread != null) {
            if (Thread.currentThread() != this.keepAliveThread) {
                this.keepAliveThread.interrupt();
            }
            this.keepAliveThread = null;
        }
        if (this.sendThread != null) {
            this.sendThread = null;
        }
        if (this.rcvThread != null) {
            this.rcvThread = null;
        }
        this.notifyAll();
    }

    public void sendAsynch(ID recipient, byte[] obj) throws IOException {
        this.queueObject(recipient, (Serializable)obj);
    }

    public void sendAsynch(ID recipient, Object obj) throws IOException {
        this.queueObject(recipient, (Serializable)obj);
    }

    public synchronized void queueObject(ID recipient, Serializable obj) throws IOException {
        if (this.queue.isStopped() || this.isClosing) {
            throw new ConnectException("Not connected");
        }
        this.queue.enqueue((Object)new AsynchMessage(obj));
    }

    public synchronized Serializable sendObject(ID recipient, Serializable obj) throws IOException {
        if (this.queue.isStopped() || this.isClosing) {
            throw new ConnectException("Not connected");
        }
        this.sendClose(new SynchMessage(obj));
        return null;
    }

    public Object sendSynch(ID rec, Object obj) throws IOException {
        return this.sendObject(rec, (Serializable)obj);
    }

    public Object sendSynch(ID rec, byte[] obj) throws IOException {
        return this.sendObject(rec, (Serializable)obj);
    }

    Serializable readObject() throws IOException {
        Serializable ret = null;
        try {
            ret = (Serializable)this.inputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            this.traceStack("readObject;classnotfoundexception", e);
            IOException except = new IOException("Protocol violation due to class load failure");
            except.setStackTrace(e.getStackTrace());
            throw except;
        }
        return ret;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    String getAddressPort() {
        return this.addressPort;
    }

    protected void debug(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/connection", (String)(this.getLocalID() + "." + msg));
    }

    protected void traceStack(String msg, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", Client.class, (String)msg, (Throwable)e);
    }

    public void setProperties(Map props) {
        this.properties = props;
    }

    public Object getOutputStreamLock() {
        return this.outputStreamLock;
    }
}

