/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.filetransfer.ui;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.filetransfer.IFileTransfer;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.ui.FileTransfersView;
import org.eclipse.ecf.internal.filetransfer.ui.Activator;
import org.eclipse.ecf.internal.filetransfer.ui.StartFileDownloadDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class GetFileHandler
extends AbstractHandler {
    private static final String SCP_JOB_FAMILY = "scp";
    FileTransfersView fileTransfersView;

    void addTransferToView(Shell shell, final IIncomingFileTransfer incoming, final String localFileName) {
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GetFileHandler.this.fileTransfersView = FileTransfersView.addTransfer((IFileTransfer)incoming, localFileName);
            }
        });
    }

    void updateTransferInView(Shell shell, final IIncomingFileTransfer incoming) {
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GetFileHandler.this.fileTransfersView != null) {
                    GetFileHandler.this.fileTransfersView.update((IFileTransfer)incoming);
                }
            }
        });
    }

    void completeTransferInView(Shell shell, IIncomingFileTransfer incoming) {
        this.updateTransferInView(shell, incoming);
    }

    public void openStartFileDownloadDialog(final Shell shell, String url) {
        StartFileDownloadDialog dialog = new StartFileDownloadDialog(shell, url);
        if (dialog.open() == 0) {
            final String scp = dialog.getValue();
            final String userid = dialog.userid;
            final String passwd = dialog.passwd;
            final String fileName = dialog.filename;
            new Job(SCP_JOB_FAMILY){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IContainer container = ContainerFactory.getDefault().createContainer();
                        IRetrieveFileTransferContainerAdapter adapter = (IRetrieveFileTransferContainerAdapter)container.getAdapter(IRetrieveFileTransferContainerAdapter.class);
                        final FileOutputStream out = new FileOutputStream(fileName);
                        IFileTransferListener listener = new IFileTransferListener(){
                            IIncomingFileTransfer incoming = null;

                            public void handleTransferEvent(IFileTransferEvent event) {
                                if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                                    IIncomingFileTransferReceiveStartEvent rse = (IIncomingFileTransferReceiveStartEvent)event;
                                    try {
                                        this.incoming = rse.receive((OutputStream)out);
                                        GetFileHandler.this.addTransferToView(shell, this.incoming, fileName);
                                    }
                                    catch (IOException e) {
                                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.filetransfer.ui", "failed to set output file", (Throwable)e));
                                    }
                                } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
                                    GetFileHandler.this.updateTransferInView(shell, this.incoming);
                                } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException e) {
                                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.filetransfer.ui", "failed to close output file", (Throwable)e));
                                    }
                                    GetFileHandler.this.completeTransferInView(shell, this.incoming);
                                }
                            }
                        };
                        adapter.setConnectContextForAuthentication(ConnectContextFactory.createUsernamePasswordConnectContext((String)userid, (Object)passwd));
                        monitor.beginTask(GetFileHandler.SCP_JOB_FAMILY, -1);
                        adapter.sendRetrieveRequest(FileIDFactory.getDefault().createFileID(adapter.getRetrieveNamespace(), scp), listener, null);
                    }
                    catch (Exception e) {
                        monitor.done();
                        return new Status(4, "org.eclipse.ecf.filetransfer.ui", "get file failed", (Throwable)e);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public Object execute(ExecutionEvent o) throws ExecutionException {
        this.openStartFileDownloadDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)o), null);
        return null;
    }
}

