/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.IDUtil;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescription
extends org.osgi.service.remoteserviceadmin.EndpointDescription {
    private String idNamespace;
    private ID containerID;
    private ID connectTargetID;
    private ID[] idFilter;
    private String rsFilter;
    private Map overrides;

    public EndpointDescription(ServiceReference reference, Map<String, Object> properties) {
        super(reference, properties);
        this.verifyECFProperties();
    }

    public EndpointDescription(Map<String, Object> properties) {
        super(properties);
        this.verifyECFProperties();
    }

    private void verifyECFProperties() {
        this.idNamespace = this.verifyStringProperty("ecf.endpoint.id.ns");
        this.containerID = this.verifyIDProperty(this.idNamespace, this.getId());
        this.connectTargetID = this.verifyIDProperty("ecf.endpoint.connecttarget.id");
        this.idFilter = this.verifyIDFilter();
        this.rsFilter = this.verifyStringProperty("ecf.endpoint.rsfilter");
    }

    private String verifyStringProperty(String propName) {
        Object r = this.getProperties().get(propName);
        try {
            return (String)r;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("property value is not a String: " + propName);
            iae.initCause(e);
            throw iae;
        }
    }

    private ID verifyIDProperty(String idNamespace, String idName) {
        if (idName == null) {
            return null;
        }
        try {
            return IDUtil.createID(idNamespace, idName);
        }
        catch (IDCreateException e) {
            return IDFactory.getDefault().createStringID(idName);
        }
    }

    private ID verifyIDProperty(String namePropName) {
        return this.verifyIDProperty(this.idNamespace, this.verifyStringProperty(namePropName));
    }

    private ID[] verifyIDFilter() {
        List idNames = PropertiesUtil.getStringPlusProperty(this.getProperties(), "ecf.endpoint.idfilter.ids");
        if (idNames.size() == 0) {
            return null;
        }
        ArrayList<ID> results = new ArrayList<ID>();
        String idNamespace = this.getIdNamespace();
        for (String idName : idNames) {
            try {
                results.add(IDUtil.createID(idNamespace, idName));
            }
            catch (IDCreateException e) {
                IllegalArgumentException iae = new IllegalArgumentException("cannot create ID[]: idNamespace=" + idNamespace + " idName=" + idName);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new ID[results.size()]);
    }

    public Map<String, Version> getInterfaceVersions() {
        List interfaces = this.getInterfaces();
        HashMap<String, Version> result = new HashMap<String, Version>();
        for (String intf : interfaces) {
            int index = intf.lastIndexOf(46);
            if (index == -1) continue;
            String packageName = intf.substring(0, index);
            result.put(intf, this.getPackageVersion(packageName));
        }
        return result;
    }

    public ID getContainerID() {
        return this.containerID;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public ID getConnectTargetID() {
        return this.connectTargetID;
    }

    public ID[] getIDFilter() {
        return this.idFilter;
    }

    public String getRemoteServiceFilter() {
        return this.rsFilter;
    }

    void setPropertiesOverrides(Map propertiesOverrides) {
        this.overrides = PropertiesUtil.mergeProperties(super.getProperties(), (Map<String, Object>)propertiesOverrides);
    }

    public boolean isSameService(org.osgi.service.remoteserviceadmin.EndpointDescription other) {
        if (this == other) {
            return true;
        }
        String frameworkId = this.getFrameworkUUID();
        if (frameworkId == null) {
            return false;
        }
        return this.getId().equals(other.getId()) && this.getServiceId() == other.getServiceId() && frameworkId.equals(other.getFrameworkUUID());
    }

    public Map<String, Object> getProperties() {
        if (this.overrides != null) {
            return this.overrides;
        }
        return super.getProperties();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ECFEndpointDescription[");
        sb.append("id").append(this.getId());
        sb.append(";endpoint.service.id=").append(this.getServiceId());
        sb.append(";frameworkid=").append(this.getFrameworkUUID()).append("]");
        return sb.toString();
    }
}

