/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.presence.IAccountManager;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class XMPPContainerAccountManager
implements IAccountManager {
    private static final String NOT_CONNECTED = "not connected";
    private AccountManager accountManager = null;

    protected void traceAndThrow(String msg, Throwable t) throws ECFException {
        throw new ECFException(msg, t);
    }

    protected AccountManager getAccountManagerOrThrowIfNull() throws ECFException {
        if (this.accountManager == null) {
            throw new ECFException(NOT_CONNECTED);
        }
        return this.accountManager;
    }

    public void dispose() {
        this.accountManager = null;
    }

    public void setConnection(XMPPConnection connection) {
        this.accountManager = connection == null ? null : new AccountManager(connection);
    }

    public boolean changePassword(String newpassword) throws ECFException {
        try {
            this.getAccountManagerOrThrowIfNull().changePassword(newpassword);
        }
        catch (XMPPException e) {
            this.traceAndThrow("server exception changing password", e);
        }
        return true;
    }

    public boolean createAccount(String username, String password, Map attributes) throws ECFException {
        try {
            this.getAccountManagerOrThrowIfNull().createAccount(username, password, attributes);
        }
        catch (XMPPException e) {
            this.traceAndThrow("server exception creating account for " + username, e);
        }
        return true;
    }

    public boolean deleteAccount() throws ECFException {
        try {
            this.getAccountManagerOrThrowIfNull().deleteAccount();
        }
        catch (XMPPException e) {
            this.traceAndThrow("server exception deleting account", e);
        }
        return true;
    }

    public String getAccountCreationInstructions() {
        if (this.accountManager == null) {
            return "";
        }
        return this.accountManager.getAccountInstructions();
    }

    public String[] getAccountAttributeNames() {
        if (this.accountManager == null) {
            return new String[0];
        }
        Iterator i = this.accountManager.getAccountAttributes().iterator();
        ArrayList l = new ArrayList();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l.toArray(new String[0]);
    }

    public Object getAccountAttribute(String name) {
        if (this.accountManager == null) {
            return null;
        }
        return this.accountManager.getAccountAttribute(name);
    }

    public boolean isAccountCreationSupported() {
        if (this.accountManager == null) {
            return false;
        }
        return this.accountManager.supportsAccountCreation();
    }
}

