/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.node.internal;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.node.internal.WatchManager;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;

class WriteRoot
implements Watcher {
    private ZooKeeper writeKeeper;
    private String ip;
    private WatchManager watchManager;
    private boolean isConnected;
    private Object connectionLock = new Object();

    WriteRoot(String ip, WatchManager watchManager) {
        Assert.isNotNull((Object)ip);
        Assert.isNotNull((Object)watchManager);
        this.ip = ip;
        this.watchManager = watchManager;
        this.initWriteKeeper();
    }

    public void process(final WatchedEvent event) {
        ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = WriteRoot.this.connectionLock;
                synchronized (object) {
                    switch (event.getState()) {
                        case Disconnected: {
                            WriteRoot.this.isConnected = false;
                            WriteRoot.this.watchManager.unpublishAll();
                            WriteRoot.this.connect();
                            break;
                        }
                        case Expired: {
                            WriteRoot.this.isConnected = false;
                            WriteRoot.this.watchManager.unpublishAll();
                            WriteRoot.this.connect();
                            break;
                        }
                        case SyncConnected: {
                            if (WriteRoot.this.isConnected) break;
                            WriteRoot.this.isConnected = true;
                            WriteRoot.this.watchManager.addZooKeeper(WriteRoot.this.writeKeeper);
                            WriteRoot.this.watchManager.republishAll();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.isConnected || this.watchManager.isDisposed()) {
                return;
            }
            try {
                if (this.writeKeeper != null) {
                    this.writeKeeper.close();
                    this.watchManager.removeZooKeeper(this.writeKeeper);
                    this.writeKeeper = null;
                }
                this.writeKeeper = new ZooKeeper(this.ip, 3000, (Watcher)this);
            }
            catch (Exception e) {
                Logger.log(4, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initWriteKeeper() {
        try {
            if (this.watchManager.getConfig().isQuorum() || this.watchManager.getConfig().isStandAlone()) {
                port = this.watchManager.getConfig().getClientPort();
                if (port != 0) {
                    this.ip = String.valueOf(this.ip) + ":" + port;
                }
            } else if (this.watchManager.getConfig().isCentralized()) {
                this.ip = this.watchManager.getConfig().getServerIps();
            }
            try {
                this.writeKeeper = new ZooKeeper(this.ip, 3000, (Watcher)this);
                if (true) ** GOTO lbl43
            }
            catch (Exception e) {
                Logger.log(1, "Fatal error while initializing a zookeeper client to write to: " + this.ip, e);
                throw new IllegalStateException(e);
            }
            do {
                e = this.connectionLock;
                synchronized (e) {
                    if (this.watchManager.isDisposed()) {
                        try {
                            this.writeKeeper.close();
                        }
                        catch (Throwable var2_7) {
                            // empty catch block
                        }
                        break;
                    }
                    try {
                        s = this.writeKeeper.exists("/zoodiscovery_root", (Watcher)this);
                        this.isConnected = true;
                        if (s == null) {
                            this.writeKeeper.create("/zoodiscovery_root", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        }
                    }
                    catch (KeeperException e) {
                        if (e.code().equals((Object)KeeperException.Code.CONNECTIONLOSS)) {
                            this.isConnected = false;
                            PrettyPrinter.attemptingConnectionTo(this.ip);
                        }
                        Logger.log(1, "Error while trying to connect to " + this.ip, (Exception)e);
                    }
                }
lbl43:
                // 4 sources

            } while (!this.isConnected);
            e = this;
            synchronized (e) {
                this.notifyAll();
            }
        }
        catch (Exception e) {
            Logger.log(4, e.getMessage(), e);
        }
    }

    public ZooKeeper getWriteKeeper() {
        return this.writeKeeper;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public WatchManager getWatchManager() {
        return this.watchManager;
    }
}

