/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core.internal;

import java.util.concurrent.Executors;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.provider.zookeeper.DiscoveryActivator;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.core.internal.Notification;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Localizer {
    private ServiceTracker serviceListenerTracker;
    private ServiceTracker serviceTypeListenerTracker;
    private static Localizer singleton;

    private Localizer() {
    }

    public static Localizer getSingleton() {
        if (singleton == null) {
            singleton = new Localizer();
        }
        return singleton;
    }

    public void init() {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                BundleContext context = DiscoveryActivator.getContext();
                final ZooDiscoveryContainer discovery = ZooDiscoveryContainer.getSingleton();
                Localizer.this.serviceListenerTracker = new ServiceTracker(context, IServiceListener.class.getName(), null){

                    public Object addingService(ServiceReference reference) {
                        discovery.addServiceListener((IServiceListener)this.context.getService(reference));
                        return super.addingService(reference);
                    }

                    public void modifiedService(ServiceReference reference, Object service) {
                        discovery.removeServiceListener((IServiceListener)this.context.getService(reference));
                        discovery.addServiceListener((IServiceListener)this.context.getService(reference));
                        super.modifiedService(reference, service);
                    }

                    public void removedService(ServiceReference reference, Object service) {
                        discovery.removeServiceListener((IServiceListener)this.context.getService(reference));
                        super.removedService(reference, service);
                    }
                };
                Localizer.this.serviceListenerTracker.open(true);
                Localizer.this.serviceTypeListenerTracker = new ServiceTracker(context, IServiceTypeListener.class.getName(), null){

                    public Object addingService(ServiceReference reference) {
                        discovery.addServiceTypeListener((IServiceTypeListener)this.context.getService(reference));
                        return super.addingService(reference);
                    }

                    public void modifiedService(ServiceReference reference, Object service) {
                        discovery.removeServiceTypeListener((IServiceTypeListener)this.context.getService(reference));
                        discovery.addServiceTypeListener((IServiceTypeListener)this.context.getService(reference));
                        super.modifiedService(reference, service);
                    }

                    public void removedService(ServiceReference reference, Object service) {
                        discovery.removeServiceTypeListener((IServiceTypeListener)this.context.getService(reference));
                        super.removedService(reference, service);
                    }
                };
                Localizer.this.serviceTypeListenerTracker.open(true);
            }
        });
    }

    public void close() {
        if (this.serviceListenerTracker != null) {
            this.serviceListenerTracker.close();
        }
        if (this.serviceTypeListenerTracker != null) {
            this.serviceTypeListenerTracker.close();
        }
    }

    public void localize(Notification notification) {
        block4: {
            block3: {
                if (notification.getType() != 1) break block3;
                for (IServiceListener srl : ZooDiscoveryContainer.getSingleton().getServiceListenersForType(notification.getServiceTypeID())) {
                    srl.serviceDiscovered((IServiceEvent)notification);
                }
                for (IServiceTypeListener stl : ZooDiscoveryContainer.getSingleton().getServiceTypeListeners()) {
                    stl.serviceTypeDiscovered((IServiceTypeEvent)notification);
                }
                break block4;
            }
            if (notification.getType() != 2) break block4;
            for (IServiceListener l : ZooDiscoveryContainer.getSingleton().getAllServiceListeners()) {
                l.serviceUndiscovered((IServiceEvent)notification);
            }
        }
    }
}

