/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.io.EOFException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryContainerAdapter;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryException;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceID;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceTypeID;
import org.eclipse.ecf.provider.dnssd.Messages;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Update;

public class DnsSdDiscoveryAdvertiser
extends DnsSdDiscoveryContainerAdapter {
    private static final String _DNS_UPDATE = "_dns-update._udp.";
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;
    static /* synthetic */ Class class$0;

    public DnsSdDiscoveryAdvertiser() {
        IIDFactory iIDFactory = IDFactory.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryAdvertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super("ecf.namespace.dnssd", new DiscoveryContainerConfig(iIDFactory.createStringID(clazz.getName())));
    }

    public void registerService(IServiceInfo serviceInfo) {
        Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"registerService(IServiceInfo serviceInfo)", (String)"Registering service");
        this.sendToServer(serviceInfo, true);
    }

    public void unregisterService(IServiceInfo serviceInfo) {
        Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"unregisterService(IServiceInfo serviceInfo)", (String)"Unregistering service");
        this.sendToServer(serviceInfo, false);
    }

    public void unregisterAllServices() {
        Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"unregisterAllServices()", (String)"Unregistering all services");
        throw new UnsupportedOperationException("Not yet implemented, see http://bugs.eclipse.org/321959");
    }

    public IServiceInfo[] purgeCache() {
        throw new UnsupportedOperationException("Not yet implemented, see http://bugs.eclipse.org/");
    }

    public void connect(ID aTargetID, IConnectContext connectContext) throws ContainerConnectException {
        Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"connect(ID aTargetID, IConnectContext connectContext)", (String)"connecting container");
        if (this.targetID != null || this.getConfig() == null) {
            throw new ContainerConnectException(Messages.DnsSdDiscoveryAdvertiser_Container_Already_Connected);
        }
        if (aTargetID == null) {
            this.targetID = new DnsSdServiceTypeID();
        } else {
            Namespace ns = this.getConnectNamespace();
            try {
                this.targetID = (DnsSdServiceTypeID)ns.createInstance(new Object[]{aTargetID});
            }
            catch (IDCreateException e) {
                throw new ContainerConnectException((Throwable)e);
            }
        }
        if (this.resolver == null) {
            try {
                this.resolver = new SimpleResolver();
                this.resolver.setTCP(true);
            }
            catch (UnknownHostException e) {
                throw new ContainerConnectException((Throwable)e);
            }
        }
        this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), (ID)this.targetID, (Object)connectContext));
        this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), (ID)this.targetID));
    }

    protected void sendToServer(IServiceInfo serviceInfo, boolean mode) {
        Assert.isNotNull((Object)serviceInfo);
        Assert.isLegal((boolean)(serviceInfo.getServiceID() instanceof DnsSdServiceID));
        DnsSdServiceID serviceID = (DnsSdServiceID)serviceInfo.getServiceID();
        try {
            Record srvRecord = serviceID.toSRVRecord();
            Record[] txtRecords = serviceID.toTXTRecords(srvRecord);
            Name name = serviceID.getDnsName();
            String[] registrationDomains = this.getRegistrationDomains(serviceID.getServiceTypeID());
            int i = 0;
            while (i < registrationDomains.length) {
                Name zone = new Name(registrationDomains[i]);
                Name fqdn = new Name(String.valueOf(name.toString()) + "." + zone.toString());
                Update update = new Update(zone);
                if (mode) {
                    update.replace(srvRecord.withName(fqdn));
                } else {
                    update.delete(srvRecord.withName(fqdn));
                }
                int j = 0;
                while (j < txtRecords.length) {
                    if (mode) {
                        update.add(txtRecords[j].withName(fqdn));
                    } else {
                        update.delete(txtRecords[j].withName(fqdn));
                    }
                    ++j;
                }
                Collection dnsServers = this.getUpdateDomain(zone);
                if (dnsServers.size() == 0) {
                    throw new DnsSdDiscoveryException(Messages.DnsSdDiscoveryAdvertiser_No_DynDns_Servers_Found);
                }
                Iterator iterator = dnsServers.iterator();
                while (iterator.hasNext()) {
                    Message response;
                    SRVRecord dnsServer = (SRVRecord)iterator.next();
                    Name target = dnsServer.getTarget();
                    try {
                        InetAddress byName = InetAddress.getByName(target.toString());
                        ((SimpleResolver)this.resolver).setAddress(byName);
                        ((SimpleResolver)this.resolver).setPort(dnsServer.getPort());
                        response = this.resolver.send((Message)update);
                    }
                    catch (UnknownHostException uhe) {
                        if (iterator.hasNext()) continue;
                        throw new DnsSdDiscoveryException(uhe);
                    }
                    catch (EOFException eof) {
                        if (iterator.hasNext()) continue;
                        throw new DnsSdDiscoveryException(eof);
                    }
                    if (response.getRcode() == 0 || iterator.hasNext()) continue;
                    throw DnsSdDiscoveryException.getException(response.getRcode());
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new DnsSdDiscoveryException(e);
        }
    }

    protected Collection getUpdateDomain(Name zone) throws TextParseException {
        Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"getUpdateDomain(Name zone)", (String)"Getting update domain");
        Lookup query = new Lookup(_DNS_UPDATE + zone, 33);
        SortedSet srvRecords = this.getSRVRecord(query, new DnsSdDiscoveryContainerAdapter.SRVRecordComparator());
        if (srvRecords.size() == 0) {
            Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"getUpdateDomain(Name zone)", (String)"Found no _dns-update SRV records in zone");
            return this.getAuthoritativeNameServer(zone);
        }
        return srvRecords;
    }

    protected Collection getAuthoritativeNameServer(Name zone) throws TextParseException {
        Record record;
        Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"getAuthoritativeNameServer(Name zone)", (String)"Trying to find authoritative name server");
        HashSet<SRVRecord> result = new HashSet<SRVRecord>();
        Name name = new Name(_DNS_UPDATE + zone);
        Lookup query = new Lookup(zone, 2);
        query.setResolver(this.resolver);
        Record[] queryResult = query.run();
        int length = queryResult == null ? 0 : queryResult.length;
        int j = 0;
        while (j < length) {
            record = queryResult[j];
            if (record instanceof NSRecord) {
                NSRecord nsRecord = (NSRecord)record;
                Name target = nsRecord.getTarget();
                result.add(new SRVRecord(name, 1, nsRecord.getTTL(), 0, 0, 53, target));
            }
            ++j;
        }
        query = new Lookup(zone, 6);
        query.setResolver(this.resolver);
        queryResult = query.run();
        length = queryResult == null ? 0 : queryResult.length;
        j = 0;
        while (j < length) {
            record = queryResult[j];
            if (record instanceof SOARecord) {
                SOARecord soaRecord = (SOARecord)record;
                result.add(new SRVRecord(name, 1, soaRecord.getTTL(), 0, 0, 53, soaRecord.getHost()));
            }
            ++j;
        }
        return result;
    }

    protected String[] getRegistrationDomains(IServiceTypeID aServiceTypeId) {
        Trace.trace((String)"org.eclipse.ecf.provider.dnssd", (String)"org.eclipse.ecf.provider.dnssd/debug/methods/tracing", ((Object)((Object)this)).getClass(), (String)"getRegistrationDomains(IServiceTypeID aServiceTypeId)", (String)"Getting registration domains");
        String[] rrs = new String[]{"r._dns-sd", "dr._dns-sd"};
        Collection registrationDomains = this.getBrowsingOrRegistrationDomains(aServiceTypeId, rrs);
        String[] scopes = aServiceTypeId.getScopes();
        int i = 0;
        while (i < scopes.length) {
            scopes[i] = scopes[i].concat(".");
            ++i;
        }
        return registrationDomains.size() == 0 ? scopes : registrationDomains.toArray(new String[registrationDomains.size()]);
    }

    public String getContainerName() {
        return "ecf.discovery.dnssd.advertiser";
    }
}

