/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.net.URI;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceID;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceTypeID;
import org.eclipse.ecf.provider.dnssd.Messages;

public class DnsSdNamespace
extends Namespace {
    private static final long serialVersionUID = 7902507535188221743L;
    public static final String SCHEME = "dnssd";
    public static final String NAME = "ecf.namespace.dnssd";

    public DnsSdNamespace() {
        super(NAME, "Dns SD Namespace");
    }

    public ID createInstance(Object[] parameters) throws IDCreateException {
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof String) {
            String str = (String)parameters[0];
            return new DnsSdServiceTypeID((Namespace)this, str);
        }
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof IServiceTypeID) {
            IServiceTypeID serviceTypeID = (IServiceTypeID)parameters[0];
            return new DnsSdServiceTypeID((Namespace)this, serviceTypeID);
        }
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof IServiceID) {
            IServiceID serviceID = (IServiceID)parameters[0];
            return new DnsSdServiceTypeID((Namespace)this, serviceID.getServiceTypeID());
        }
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof StringID) {
            StringID stringID = (StringID)parameters[0];
            return new DnsSdServiceTypeID((Namespace)this, stringID.getName());
        }
        if (parameters != null && parameters.length == 2 && parameters[0] instanceof IServiceTypeID && parameters[1] instanceof URI) {
            IServiceTypeID serviceTypeID = (IServiceTypeID)parameters[0];
            URI uri = (URI)parameters[1];
            return new DnsSdServiceID(this, new DnsSdServiceTypeID((Namespace)this, serviceTypeID), uri);
        }
        if (parameters != null && parameters.length == 2 && parameters[0] instanceof String && parameters[1] instanceof URI) {
            String serviceType = (String)parameters[0];
            URI uri = (URI)parameters[1];
            return new DnsSdServiceID(this, new DnsSdServiceTypeID((Namespace)this, serviceType), uri);
        }
        throw new IDCreateException(Messages.DnsSdNamespace_Wrong_Parameters);
    }

    public String getScheme() {
        return SCHEME;
    }

    public Class[][] getSupportedParameterTypes() {
        return new Class[][]{{String.class}, {IServiceTypeID.class}, {IServiceTypeID.class, URI.class}, {String.class, URI.class}};
    }
}

