/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;

public class ResolverConfig {
    private String[] servers = null;
    private Name[] searchlist = null;
    private static ResolverConfig currentConfig;

    public ResolverConfig() {
        if (this.findProperty()) {
            return;
        }
        if (this.findSunJVM()) {
            return;
        }
        if (this.servers == null || this.searchlist == null) {
            String OS = System.getProperty("os.name");
            String vendor = System.getProperty("java.vendor");
            if (OS.indexOf("Windows") != -1) {
                if (OS.indexOf("95") != -1 || OS.indexOf("98") != -1 || OS.indexOf("ME") != -1) {
                    this.find95();
                } else {
                    this.findNT();
                }
            } else if (OS.indexOf("NetWare") != -1) {
                this.findNetware();
            } else if (vendor.indexOf("Android") != -1) {
                this.findAndroid();
            } else {
                this.findUnix();
            }
        }
    }

    private void addServer(String server, List list) {
        if (list.contains(server)) {
            return;
        }
        if (Options.check("verbose")) {
            System.out.println("adding server " + server);
        }
        list.add(server);
    }

    private void addSearch(String search, List list) {
        Name name;
        if (Options.check("verbose")) {
            System.out.println("adding search " + search);
        }
        try {
            name = Name.fromString(search, Name.root);
        }
        catch (TextParseException e) {
            return;
        }
        if (list.contains(name)) {
            return;
        }
        list.add(name);
    }

    private void configureFromLists(List lserver, List lsearch) {
        if (this.servers == null && lserver.size() > 0) {
            this.servers = lserver.toArray(new String[0]);
        }
        if (this.searchlist == null && lsearch.size() > 0) {
            this.searchlist = lsearch.toArray(new Name[0]);
        }
    }

    private boolean findProperty() {
        StringTokenizer st;
        ArrayList lserver = new ArrayList(0);
        ArrayList lsearch = new ArrayList(0);
        String prop = System.getProperty("dns.server");
        if (prop != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                this.addServer(st.nextToken(), lserver);
            }
        }
        if ((prop = System.getProperty("dns.search")) != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                this.addSearch(st.nextToken(), lsearch);
            }
        }
        this.configureFromLists(lserver, lsearch);
        return this.servers != null && this.searchlist != null;
    }

    private boolean findSunJVM() {
        Iterator it;
        List lsearch_tmp;
        List lserver_tmp;
        ArrayList lserver = new ArrayList(0);
        ArrayList lsearch = new ArrayList(0);
        try {
            Class[] noClasses = new Class[]{};
            Object[] noObjects = new Object[]{};
            String resConfName = "sun.net.dns.ResolverConfiguration";
            Class<?> resConfClass = Class.forName(resConfName);
            Method open = resConfClass.getDeclaredMethod("open", noClasses);
            Object resConf = open.invoke(null, noObjects);
            Method nameservers = resConfClass.getMethod("nameservers", noClasses);
            lserver_tmp = (List)nameservers.invoke(resConf, noObjects);
            Method searchlist = resConfClass.getMethod("searchlist", noClasses);
            lsearch_tmp = (List)searchlist.invoke(resConf, noObjects);
        }
        catch (Exception e) {
            return false;
        }
        if (lserver_tmp.size() == 0) {
            return false;
        }
        if (lserver_tmp.size() > 0) {
            it = lserver_tmp.iterator();
            while (it.hasNext()) {
                this.addServer((String)it.next(), lserver);
            }
        }
        if (lsearch_tmp.size() > 0) {
            it = lsearch_tmp.iterator();
            while (it.hasNext()) {
                this.addSearch((String)it.next(), lsearch);
            }
        }
        this.configureFromLists(lserver, lsearch);
        return true;
    }

    private void findResolvConf(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return;
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        ArrayList lserver = new ArrayList(0);
        ArrayList lsearch = new ArrayList(0);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st;
                if (line.startsWith("nameserver")) {
                    st = new StringTokenizer(line);
                    st.nextToken();
                    this.addServer(st.nextToken(), lserver);
                    continue;
                }
                if (line.startsWith("domain")) {
                    st = new StringTokenizer(line);
                    st.nextToken();
                    if (!st.hasMoreTokens() || !lsearch.isEmpty()) continue;
                    this.addSearch(st.nextToken(), lsearch);
                    continue;
                }
                if (!line.startsWith("search")) continue;
                if (!lsearch.isEmpty()) {
                    lsearch.clear();
                }
                st = new StringTokenizer(line);
                st.nextToken();
                while (st.hasMoreTokens()) {
                    this.addSearch(st.nextToken(), lsearch);
                }
            }
            br.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.configureFromLists(lserver, lsearch);
    }

    private void findUnix() {
        this.findResolvConf("/etc/resolv.conf");
    }

    private void findNetware() {
        this.findResolvConf("sys:/etc/resolv.cfg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findWin(InputStream in) {
        String packageName = ResolverConfig.class.getPackage().getName();
        String resPackageName = packageName + ".windows.DNSServer";
        ResourceBundle res = ResourceBundle.getBundle(resPackageName);
        String host_name = res.getString("host_name");
        String primary_dns_suffix = res.getString("primary_dns_suffix");
        String dns_suffix = res.getString("dns_suffix");
        String dns_servers = res.getString("dns_servers");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            ArrayList lserver = new ArrayList();
            ArrayList lsearch = new ArrayList();
            String line = null;
            boolean readingServers = false;
            boolean readingSearches = false;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    readingServers = false;
                    readingSearches = false;
                    continue;
                }
                String s = st.nextToken();
                if (line.indexOf(":") != -1) {
                    readingServers = false;
                    readingSearches = false;
                }
                if (line.indexOf(host_name) != -1) {
                    Name name;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    try {
                        name = Name.fromString(s, null);
                    }
                    catch (TextParseException e) {
                        continue;
                    }
                    if (name.labels() == 1) continue;
                    this.addSearch(s, lsearch);
                    continue;
                }
                if (line.indexOf(primary_dns_suffix) != -1) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (s.equals(":")) continue;
                    this.addSearch(s, lsearch);
                    readingSearches = true;
                    continue;
                }
                if (readingSearches || line.indexOf(dns_suffix) != -1) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (s.equals(":")) continue;
                    this.addSearch(s, lsearch);
                    readingSearches = true;
                    continue;
                }
                if (!readingServers && line.indexOf(dns_servers) == -1) continue;
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                }
                if (s.equals(":")) continue;
                this.addServer(s, lserver);
                readingServers = true;
            }
            this.configureFromLists(lserver, lsearch);
        }
        catch (IOException e) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {}
        }
    }

    private void find95() {
        String s = "winipcfg.out";
        try {
            Process p = Runtime.getRuntime().exec("winipcfg /all /batch " + s);
            p.waitFor();
            File f = new File(s);
            this.findWin(new FileInputStream(f));
            new File(s).delete();
        }
        catch (Exception e) {
            return;
        }
    }

    private void findNT() {
        try {
            Process p = Runtime.getRuntime().exec("ipconfig /all");
            this.findWin(p.getInputStream());
            p.destroy();
        }
        catch (Exception e) {
            return;
        }
    }

    private void findAndroid() {
        String re1 = "^\\d+(\\.\\d+){3}$";
        String re2 = "^[0-9a-f]+(:[0-9a-f]*)+:[0-9a-f]+$";
        try {
            String line;
            ArrayList<String> maybe = new ArrayList<String>();
            Process p = Runtime.getRuntime().exec("getprop");
            InputStream in = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                StringTokenizer t = new StringTokenizer(line, ":");
                String name = t.nextToken();
                if (name.indexOf(".dns") <= -1) continue;
                String v = t.nextToken();
                if (!(v = v.replaceAll("[ \\[\\]]", "")).matches(re1) && !v.matches(re2) || maybe.contains(v)) continue;
                maybe.add(v);
            }
            this.configureFromLists(maybe, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] servers() {
        return this.servers;
    }

    public String server() {
        if (this.servers == null) {
            return null;
        }
        return this.servers[0];
    }

    public Name[] searchPath() {
        return this.searchlist;
    }

    public static synchronized ResolverConfig getCurrentConfig() {
        return currentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        ResolverConfig newConfig = new ResolverConfig();
        Class clazz = ResolverConfig.class;
        synchronized (clazz) {
            currentConfig = newConfig;
        }
    }

    static {
        ResolverConfig.refresh();
    }
}

