/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.LastActivity;

public class LastActivityManager {
    private long lastMessageSent;
    private Connection connection;

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                new LastActivityManager(connection, null);
            }
        });
    }

    private LastActivityManager(Connection connection) {
        this.connection = connection;
        connection.addPacketSendingListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                Presence.Mode mode = presence.getMode();
                if (mode == null) {
                    return;
                }
                switch (mode) {
                    case chat: 
                    case available: {
                        LastActivityManager.this.resetIdleTime();
                    }
                }
            }
        }, new PacketTypeFilter(Presence.class));
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                if (message.getType() == Message.Type.error) {
                    return;
                }
                LastActivityManager.this.resetIdleTime();
            }
        }, new PacketTypeFilter(Message.class));
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                LastActivity message = new LastActivity();
                message.setType(IQ.Type.RESULT);
                message.setTo(packet.getFrom());
                message.setFrom(packet.getTo());
                message.setPacketID(packet.getPacketID());
                message.setLastActivity(LastActivityManager.this.getIdleTime());
                LastActivityManager.this.connection.sendPacket(message);
            }
        }, new AndFilter(new IQTypeFilter(IQ.Type.GET), new PacketTypeFilter(LastActivity.class)));
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature("jabber:iq:last");
        this.resetIdleTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIdleTime() {
        long now = System.currentTimeMillis();
        LastActivityManager lastActivityManager = this;
        synchronized (lastActivityManager) {
            this.lastMessageSent = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIdleTime() {
        long lms;
        long now = System.currentTimeMillis();
        LastActivityManager lastActivityManager = this;
        synchronized (lastActivityManager) {
            lms = this.lastMessageSent;
        }
        return (now - lms) / 1000L;
    }

    public static LastActivity getLastActivity(Connection con, String jid) throws XMPPException {
        LastActivity activity = new LastActivity();
        activity.setTo(jid);
        PacketCollector collector = con.createPacketCollector(new PacketIDFilter(activity.getPacketID()));
        con.sendPacket(activity);
        LastActivity response = (LastActivity)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return response;
    }

    public static boolean isLastActivitySupported(Connection connection, String jid) {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(jid);
            return result.containsFeature("jabber:iq:last");
        }
        catch (XMPPException e) {
            return false;
        }
    }

    /* synthetic */ LastActivityManager(Connection connection, LastActivityManager lastActivityManager) {
        this(connection);
    }
}

