/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.irc";
    private static Activator plugin;
    private BundleContext bundleContext = null;
    private ServiceTracker logServiceTracker = null;
    private LogService logService;

    public static void log(String message) {
        Activator.getDefault().log((IStatus)new Status(0, PLUGIN_ID, 0, message, null));
    }

    public static void log(String message, Throwable e) {
        Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 0, "Caught exception", e));
    }

    protected LogService getLogService() {
        if (this.logService == null) {
            if (this.logServiceTracker == null) {
                this.logServiceTracker = new ServiceTracker(this.bundleContext, LogService.class.getName(), null);
                this.logServiceTracker.open();
            }
            this.logService = (LogService)this.logServiceTracker.getService();
            if (this.logService == null) {
                this.logService = new SystemLogService(PLUGIN_ID);
            }
        }
        return this.logService;
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        this.bundleContext = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    public boolean hasDatashare() {
        if (this.bundleContext == null) {
            return false;
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getSymbolicName().equals("org.eclipse.ecf.provider.datashare.nio")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

