/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerTransaction;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddAbortException;
import org.eclipse.ecf.example.collab.share.GenericSharedObject;
import org.eclipse.ecf.example.collab.share.SharedObjectMsg;
import org.eclipse.ecf.internal.example.collab.Messages;

public class TransactionSharedObject
extends GenericSharedObject
implements ISharedObjectContainerTransaction {
    public static final String REPLICA_COMMIT_MSG = "replicaCommit";
    public static int DEFAULT_TIMEOUT = 30000;
    protected int timeout;
    protected byte state;
    protected Lock lock;
    protected Vector participantIDs;
    protected Hashtable failedParticipants;

    public TransactionSharedObject(int timeout) {
        this.timeout = timeout;
        this.init();
    }

    public TransactionSharedObject() {
        this(DEFAULT_TIMEOUT);
    }

    protected void init() {
        this.state = 0;
        this.lock = new Lock();
        this.participantIDs = new Vector();
        this.failedParticipants = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activated(ID[] others) {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.isHost()) {
                this.replicate(null);
                this.addRemoteParticipants(this.getContext().getGroupMemberIDs());
                this.state = 1;
            } else {
                try {
                    this.getContext().sendCreateResponse(this.getHomeContainerID(), null, TransactionSharedObject.getNextReplicateID());
                    this.state = (byte)2;
                }
                catch (Exception e) {
                    this.state = (byte)4;
                    this.log("unable to send create response to " + this.getHomeContainerID(), e);
                }
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberAdded(ID member) {
        if (this.isHost()) {
            Lock lock = this.lock;
            synchronized (lock) {
                this.replicate(member);
                if (this.getTransactionState() == 1) {
                    this.addRemoteParticipants(new ID[]{member});
                } else {
                    this.replicate(member);
                }
            }
        }
    }

    protected void addRemoteParticipants(ID[] ids) {
        if (ids != null && this.participantIDs != null) {
            int i = 0;
            while (i < ids.length) {
                if (!this.getHomeContainerID().equals((Object)ids[i])) {
                    this.participantIDs.addElement(ids[i]);
                }
                ++i;
            }
        }
    }

    protected void removeRemoteParticipant(ID id) {
        int index;
        if (id != null && this.participantIDs != null && (index = this.participantIDs.indexOf(id)) != -1) {
            this.participantIDs.removeElementAt(index);
        }
    }

    protected void addRemoteParticipantFailed(ID remote, Throwable failure) {
        if (remote != null && failure != null && this.failedParticipants != null) {
            this.failedParticipants.put(remote, failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateResponse(ID fromID, Throwable e, Long identifier) {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.state == 1) {
                if (e == null) {
                    this.removeRemoteParticipant(fromID);
                } else {
                    this.addRemoteParticipantFailed(fromID, e);
                }
            } else {
                this.handleVotingCompletedCreateResponse(fromID, e, identifier);
            }
            this.lock.notifyAll();
        }
    }

    protected void handleVotingCompletedCreateResponse(ID fromID, Throwable e, Long identifier) {
        if (e == null) {
            try {
                this.forwardMsgTo(fromID, SharedObjectMsg.createMsg(null, REPLICA_COMMIT_MSG));
            }
            catch (Exception except) {
                this.log("Exception sending commit message to " + fromID, except);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberRemoved(ID member) {
        if (this.isHost()) {
            Lock lock = this.lock;
            synchronized (lock) {
                if (this.state == 1) {
                    this.addRemoteParticipantFailed(member, new Exception("Member " + member + " left"));
                }
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToCommit() throws SharedObjectAddAbortException {
        Lock lock = this.lock;
        synchronized (lock) {
            long end = System.currentTimeMillis() + (long)this.timeout;
            try {
                while (!this.votingCompleted()) {
                    long wait = end - System.currentTimeMillis();
                    if (wait <= 0L) {
                        throw new SharedObjectAddAbortException(Messages.TransactionSharedObject_EXCEPTION_TIMEOUT);
                    }
                    this.lock.wait(wait);
                }
            }
            catch (InterruptedException e) {
                throw new SharedObjectAddAbortException(Messages.TransactionSharedObject_EXCEPTION_INTERUPTED);
            }
            catch (SharedObjectAddAbortException e1) {
                this.doAbort(e1);
            }
            this.doCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getTransactionState() {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.state;
        }
    }

    protected void doAbort(SharedObjectAddAbortException e) throws SharedObjectAddAbortException {
        this.destroySelf();
        this.state = (byte)4;
        throw e;
    }

    public void doCommit() throws SharedObjectAddAbortException {
        int others = 0;
        others = this.getContext().getGroupMemberIDs().length;
        if (this.participantIDs != null && others > 0) {
            try {
                this.forwardMsgTo(null, SharedObjectMsg.createMsg(null, REPLICA_COMMIT_MSG));
            }
            catch (Exception e2) {
                this.doAbort(new SharedObjectAddAbortException(Messages.TransactionSharedObject_EXCEPTION_ON_COMMIT_MESSAGE, (Throwable)e2));
            }
        }
        this.state = (byte)3;
        this.committed();
        this.participantIDs = null;
        this.failedParticipants = null;
    }

    protected void execMsgInvoke(SharedObjectMsg msg, ID fromID, Object o) throws Exception {
        String name;
        if (o == this && (name = msg.getMethodName()).equals(REPLICA_COMMIT_MSG)) {
            this.replicaCommit();
            return;
        }
        super.execMsgInvoke(msg, fromID, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void replicaCommit() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.state = (byte)3;
            this.lock.notifyAll();
            this.participantIDs = null;
            this.failedParticipants = null;
        }
        this.committed();
    }

    protected void committed() {
    }

    protected boolean votingCompleted() throws SharedObjectAddAbortException {
        if (this.failedParticipants != null && this.failedParticipants.size() > 0) {
            ID remoteID = (ID)this.failedParticipants.keys().nextElement();
            Exception e = (Exception)this.failedParticipants.get(remoteID);
            throw new SharedObjectAddAbortException(Messages.TransactionSharedObject_EXCEPTION_FROM_ABORT, (Throwable)e);
        }
        return this.state == 1 && this.participantIDs.size() == 0;
    }

    static final class Lock {
        Lock() {
        }
    }
}

