/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class ServiceTypeRequest
extends RequestMessage {
    String namingAuthority;
    private static final String NA_ALL = "*";
    private static final String NA_DEFAULT = "";

    ServiceTypeRequest(String authority, List scopes, Locale theLocale) {
        this.funcID = (byte)9;
        this.prevRespList = new ArrayList();
        this.namingAuthority = authority != null ? authority : NA_ALL;
        this.scopeList = scopes;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.locale = theLocale == null ? SLPCore.DEFAULT_LOCALE : theLocale;
    }

    ServiceTypeRequest(DataInputStream input) throws IOException {
        this.prevRespList = ServiceTypeRequest.stringToList(input.readUTF(), ",");
        int authLen = input.readUnsignedShort();
        if (authLen == 65535) {
            this.namingAuthority = NA_ALL;
        } else if (authLen == -1) {
            this.namingAuthority = NA_DEFAULT;
        } else {
            byte[] buf = new byte[authLen];
            input.readFully(buf);
            this.namingAuthority = new String(buf);
        }
        this.scopeList = ServiceTypeRequest.stringToList(input.readUTF(), ",");
    }

    protected void writeTo(DataOutputStream out) throws IOException {
        out.writeUTF(ServiceTypeRequest.listToString(this.prevRespList, ","));
        if (this.namingAuthority.equals(NA_ALL)) {
            out.writeShort(65535);
        } else if (this.namingAuthority.equals(NA_DEFAULT)) {
            out.writeUTF(NA_DEFAULT);
        } else {
            out.writeUTF(this.namingAuthority);
        }
        out.writeUTF(ServiceTypeRequest.listToString(this.scopeList, ","));
    }

    protected int getSize() {
        int len = this.getHeaderSize() + 2 + ServiceTypeRequest.listToString(this.prevRespList, ",").length();
        len = this.namingAuthority.equals(NA_DEFAULT) || this.namingAuthority.equals(NA_ALL) ? (len += 2) : (len += 2 + this.namingAuthority.length());
        return len += 2 + ServiceTypeRequest.listToString(this.scopeList, ",").length();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(", prevRespList: " + this.prevRespList);
        if (this.namingAuthority.equals(NA_ALL)) {
            buffer.append(", namingAuthority: ALL (NA_ALL)");
        } else if (this.namingAuthority.equals(NA_DEFAULT)) {
            buffer.append(", namingAuthority: IANA (NA_DEFAULT)");
        } else {
            buffer.append(", namingAuthority: " + this.namingAuthority);
        }
        buffer.append(", scopeList: " + this.scopeList);
        return buffer.toString();
    }
}

