/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;

public class Trace {
    private static final String TRACENAME = "org.eclipse.ecf.example.collab.Trace";
    public static final String tracePrefix = "(trace)";
    public static boolean ON = false;
    protected static boolean isEclipse = false;
    protected static String pluginName = "";
    protected static String debugPrefix = "/debug/";
    protected static PrintStream printStream = null;
    String name;

    static {
        String val = System.getProperty(TRACENAME);
        printStream = Trace.getPrintStream(val);
        if (val != null) {
            ON = true;
            isEclipse = false;
        } else {
            try {
                ON = Platform.inDebugMode();
                pluginName = ClientPlugin.getDefault().getBundle().getSymbolicName();
            }
            catch (Exception e) {
                System.out.println("WARNING: Platform not available for trace");
            }
            isEclipse = true;
        }
    }

    protected static PrintStream getPrintStream(String outputFileName) {
        if (outputFileName != null) {
            try {
                File f = new File(outputFileName);
                PrintStream ps = new PrintStream(new FileOutputStream(f, true));
                System.out.println("org.eclipse.ecf.example.collab.Trace directed to " + f.getCanonicalPath());
                return ps;
            }
            catch (Exception e) {
                System.err.println("Exception opening output file '" + outputFileName + "' for tracing...using System.out");
            }
        }
        return System.out;
    }

    public static Trace create(String key) {
        if (isEclipse) {
            String res = Platform.getDebugOption((String)(String.valueOf(pluginName) + debugPrefix + key));
            if (res != null) {
                if (Boolean.valueOf(res).booleanValue()) {
                    return new Trace(String.valueOf(pluginName) + "(" + key + ")");
                }
                return null;
            }
            return null;
        }
        return new Trace(key);
    }

    public void dumpStack(Throwable e, String msg) {
        this.msg(msg);
        e.printStackTrace(printStream);
    }

    public void msg(String msg) {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(Trace.getTimeString()).append(msg);
        printStream.println(sb.toString());
    }

    protected static String getTimeString() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("[MM/dd/yy;HH:mm:ss:SSS]");
        return df.format(d);
    }

    protected Trace(String str) {
        this.name = tracePrefix + str;
    }

    public static String convertStringAToString(String[] strings) {
        if (strings == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null) {
                sb.append("(null)");
            } else {
                sb.append(strings[i]);
            }
            if (i != strings.length - 1) {
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String convertObjectAToString(Object[] objs) {
        if (objs == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] == null) {
                sb.append("(null)");
            } else {
                sb.append(objs[i].toString());
            }
            if (i != objs.length - 1) {
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    public static void setThreadDebugGroup(Object obj) {
    }
}

