/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.storage;

import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.storage.IContainerEntry;
import org.eclipse.ecf.storage.IIDEntry;
import org.eclipse.ecf.storage.IStorableContainerAdapter;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;

public class ContainerEntry
implements IContainerEntry {
    private static final String FACTORY_NAME_KEY = "factoryName";
    ISecurePreferences prefs;
    IIDEntry idEntry;
    ID containerID;
    static /* synthetic */ Class class$0;

    public ContainerEntry(IIDEntry idEntry) {
        this.idEntry = idEntry;
        ISecurePreferences prefs = idEntry.getPreferences();
        this.prefs = prefs.node("container");
    }

    public IContainer createContainer() throws ContainerCreateException {
        try {
            IStorableContainerAdapter containerAdapter;
            IContainer container = ContainerFactory.getDefault().createContainer(this.getFactoryName(), this.getContainerID());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.storage.IStorableContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((containerAdapter = (IStorableContainerAdapter)container.getAdapter((Class)clazz)) != null) {
                containerAdapter.restore(this.prefs);
            }
            return container;
        }
        catch (IDCreateException e) {
            throw new ContainerCreateException("Could not create ID for container", (Throwable)e);
        }
        catch (StorageException e) {
            throw new ContainerCreateException("Exception on restore", (Throwable)e);
        }
    }

    public void delete() {
        this.prefs.removeNode();
    }

    public ID getContainerID() throws IDCreateException {
        if (this.containerID == null) {
            this.containerID = this.idEntry.createID();
        }
        return this.containerID;
    }

    public String getFactoryName() throws StorageException {
        return this.prefs.get(FACTORY_NAME_KEY, "");
    }

    protected void setFactoryName(String factoryName, boolean encrypt) throws StorageException {
        this.prefs.put(FACTORY_NAME_KEY, factoryName, encrypt);
    }

    public ISecurePreferences getPreferences() {
        return this.prefs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ContainerEntry[");
        sb.append("idEntry=").append(this.idEntry);
        sb.append(";prefs=").append(this.getPreferences()).append("]");
        return sb.toString();
    }
}

