/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.irc.ui;

import org.eclipse.ecf.presence.ui.chatroom.MessageRenderer;

public class IRCMessageRenderer
extends MessageRenderer {
    protected static final String IRC_ME_COLOR = "org.eclipse.ecf.presence.irc.ui.meColor";
    protected static final String IRC_ME_FONT = "org.eclipse.ecf.presence.irc.ui.meFont";
    private static final String ME_PREFIX = "\u0001ACTION ";
    private static final String ME_SUFFIX = "\u0001";
    private boolean isActionMessage;

    protected void doRender() {
        String actionMessage = this.getActionMessage(this.message);
        boolean bl = this.isActionMessage = actionMessage != null;
        if (this.isActionMessage) {
            this.message = actionMessage;
        }
        super.doRender();
    }

    protected void appendNickname() {
        if (this.isActionMessage) {
            String message = String.valueOf(this.originator) + " ";
            this.append(message, IRC_ME_COLOR, null, IRC_ME_FONT);
        } else {
            super.appendNickname();
        }
    }

    protected void appendMessage() {
        if (this.isActionMessage) {
            this.append(this.message, IRC_ME_COLOR, null, IRC_ME_FONT);
        } else {
            super.appendMessage();
        }
    }

    private String getActionMessage(String message) {
        if (message.startsWith(ME_PREFIX) && message.endsWith(ME_SUFFIX)) {
            return message.substring(ME_PREFIX.length(), message.length() - ME_SUFFIX.length());
        }
        return null;
    }
}

