/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.IExceptionHandler;
import org.eclipse.ecf.internal.ui.Messages;
import org.eclipse.ecf.ui.actions.SynchContainerConnectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;

public class AsynchContainerConnectAction
extends SynchContainerConnectAction {
    public AsynchContainerConnectAction(IContainer container, ID targetID, IConnectContext connectContext, IExceptionHandler exceptionHandler, Runnable successBlock) {
        super(container, targetID, connectContext, exceptionHandler, successBlock);
    }

    public AsynchContainerConnectAction(IContainer container, ID targetID, IConnectContext connectContext, IExceptionHandler exceptionHandler) {
        super(container, targetID, connectContext, exceptionHandler);
    }

    public AsynchContainerConnectAction(IContainer container, ID targetID, IConnectContext connectContext) {
        this(container, targetID, connectContext, null);
    }

    public void dispose() {
        this.container = null;
        this.targetID = null;
        this.connectContext = null;
        this.window = null;
    }

    protected IStatus handleException(Throwable e) {
        if (this.exceptionHandler != null) {
            return this.exceptionHandler.handleException(e);
        }
        if (e instanceof ECFException) {
            return new MultiStatus("org.eclipse.ecf.ui", 4, new IStatus[]{this.getStatusForECFException((ECFException)e)}, NLS.bind((String)"Connect to {0} failed.", (Object)this.targetID.getName()), null);
        }
        return new Status(4, "org.eclipse.ecf.ui", 4, e.getLocalizedMessage(), null);
    }

    protected IStatus getStatusForECFException(ECFException exception) {
        IStatus status = exception.getStatus();
        Throwable cause = status.getException();
        if (cause instanceof ECFException) {
            return this.getStatusForECFException((ECFException)cause);
        }
        return status;
    }

    public void run(IAction action) {
        new AsynchActionJob().schedule();
    }

    public void run() {
        this.run(null);
    }

    class AsynchActionJob
    extends Job {
        public AsynchActionJob() {
            super(Messages.AsynchContainerConnectAction_JOB_NAME);
            this.setRule(new ContainerMutex(AsynchContainerConnectAction.this.getContainer()));
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            block6: {
                monitor.beginTask(NLS.bind((String)Messages.AsynchContainerConnectAction_MONITOR_BEGIN_TASK, (Object)(AsynchContainerConnectAction.this.targetID == null ? "" : AsynchContainerConnectAction.this.targetID.getName())), 100);
                monitor.worked(30);
                AsynchContainerConnectAction.this.container.connect(AsynchContainerConnectAction.this.targetID, AsynchContainerConnectAction.this.connectContext);
                if (!monitor.isCanceled()) break block6;
                AsynchContainerConnectAction.this.container.disconnect();
                IStatus iStatus2 = Status.CANCEL_STATUS;
                Object var3_5 = null;
                monitor.done();
                return iStatus2;
            }
            try {
                if (AsynchContainerConnectAction.this.successBlock != null) {
                    AsynchContainerConnectAction.this.successBlock.run();
                }
                monitor.worked(60);
                iStatus = Status.OK_STATUS;
                Object var3_6 = null;
            }
            catch (ContainerConnectException e) {
                IStatus iStatus3;
                try {
                    iStatus3 = AsynchContainerConnectAction.this.handleException(e);
                    Object var3_7 = null;
                }
                catch (Throwable throwable) {
                    Object var3_8 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
                return iStatus3;
            }
            monitor.done();
            return iStatus;
        }
    }

    class ContainerMutex
    implements ISchedulingRule {
        IContainer c;

        public ContainerMutex(IContainer container) {
            this.c = container;
        }

        protected boolean isSameContainer(IContainer other) {
            return other != null && this.c.getID().equals((Object)other.getID());
        }

        protected IContainer getContainer() {
            return AsynchContainerConnectAction.this.getContainer();
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule == this) {
                return true;
            }
            return rule instanceof ContainerMutex && this.isSameContainer(((ContainerMutex)rule).getContainer());
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

