/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.ui.hyperlink;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.provider.xmpp.ui.Activator;
import org.eclipse.ecf.internal.provider.xmpp.ui.Messages;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPConnectWizard;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPSConnectWizard;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.provider.xmpp.XMPPContainer;
import org.eclipse.ecf.provider.xmpp.XMPPSContainer;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.ecf.provider.xmpp.identity.XMPPSID;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.hyperlink.AbstractURLHyperlink;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class XMPPHyperlink
extends AbstractURLHyperlink {
    private static final String ECF_XMPP_CONTAINER_NAME = "ecf.xmpp.smack";
    private static final String ECF_XMPPS_CONTAINER_NAME = "ecf.xmpps.smack";
    private static final IContainer[] EMPTY = new IContainer[0];
    boolean isXMPPS = this.getURI().getScheme().equalsIgnoreCase("xmpps");

    protected IContainer[] getContainers() {
        IContainerManager manager = Activator.getDefault().getContainerManager();
        if (manager == null) {
            return EMPTY;
        }
        ArrayList<IContainer> results = new ArrayList<IContainer>();
        IContainer[] containers = manager.getAllContainers();
        int i = 0;
        while (i < containers.length) {
            ID connectedID = containers[i].getConnectedID();
            if (connectedID != null && (this.isXMPPS && containers[i] instanceof XMPPSContainer || !this.isXMPPS && containers[i] instanceof XMPPContainer)) {
                results.add(containers[i]);
            }
            ++i;
        }
        return results.toArray(EMPTY);
    }

    public void open() {
        IContainer[] containers = this.getContainers();
        if (containers.length > 0) {
            this.chooseAccount(containers);
        } else if (MessageDialog.openQuestion(null, (String)Messages.XMPPHyperlink_CONNECT_ACCOUNT_DIALOG_TITLE, (String)NLS.bind((String)Messages.XMPPHyperlink_CONNECT_ACCOUNT_DIALOG_MESSAGE, (Object)this.getURI().getAuthority()))) {
            super.open();
        }
    }

    private void chooseAccount(IContainer[] containers) {
        Object[] res;
        if (containers.length == 1) {
            this.openContainer(containers[0]);
            return;
        }
        final IPresenceContainerAdapter[] adapters = new IPresenceContainerAdapter[containers.length];
        int i = 0;
        while (i < containers.length) {
            adapters[i] = (IPresenceContainerAdapter)containers[i].getAdapter(IPresenceContainerAdapter.class);
            ++i;
        }
        ListDialog dialog = new ListDialog(null);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return adapters;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setInput((Object)adapters);
        dialog.setAddCancelButton(true);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(Messages.XMPPHyperlink_SELECT_ACCOUNT_TITLE);
        dialog.setMessage(Messages.XMPPHyperlink_SELECT_ACCOUNT_MESSAGE);
        dialog.setHeightInChars(adapters.length > 4 ? adapters.length : 4);
        dialog.setInitialSelections((Object[])new IPresenceContainerAdapter[]{adapters[0]});
        dialog.setLabelProvider(new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                IRosterManager manager = ((IPresenceContainerAdapter)element).getRosterManager();
                if (manager == null) {
                    return null;
                }
                return manager.getRoster().getUser().getID().getName();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        int result = dialog.open();
        if (result == 0 && (res = dialog.getResult()).length > 0) {
            this.openContainer((IContainer)res[0]);
        }
    }

    private void openMessagesView(IChatManager chatManager, ID localID, ID targetID, String localName) throws PartInitException {
        IChatMessageSender icms = chatManager.getChatMessageSender();
        ITypingMessageSender itms = chatManager.getTypingMessageSender();
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MessagesView view = (MessagesView)ww.getActivePage().showView("org.eclipse.ecf.presence.ui.MessagesView");
        view.selectTab(icms, itms, localID, targetID, localName);
    }

    private void openContainer(IContainer container) {
        IPresenceContainerAdapter presenceContainerAdapter = (IPresenceContainerAdapter)container.getAdapter(IPresenceContainerAdapter.class);
        IChatManager chatManager = presenceContainerAdapter.getChatManager();
        IRosterManager rosterManager = presenceContainerAdapter.getRosterManager();
        if (chatManager != null && rosterManager != null) {
            try {
                String targetHost;
                XMPPSID targetID;
                XMPPID localID = (XMPPID)rosterManager.getRoster().getUser().getID();
                Namespace ns = container.getConnectNamespace();
                Object object = targetID = this.isXMPPS ? new XMPPSID(ns, this.getURI().getAuthority()) : new XMPPID(ns, this.getURI().getAuthority());
                if (localID.equals((Object)targetID)) {
                    MessageDialog.openError(null, (String)Messages.XMPPHyperlink_MESSAGING_ERROR_TITLE, (String)Messages.XMPPHyperlink_MESSAGING_ERROR_MESSAGE);
                    return;
                }
                String localHost = localID.getHostname();
                if (!localHost.equals(targetHost = targetID.getHostname())) {
                    MessageDialog messageDialog = new MessageDialog(null, Messages.XMPPHyperlink_SELECT_ACTION_DIALOG_TITLE, null, NLS.bind((String)Messages.XMPPHyperlink_SELECT_ACTION_DIALOG_MESSAGE, (Object[])new Object[]{targetHost, localHost, targetID.getName(), localID.getName()}), 3, new String[]{Messages.XMPPHyperlink_SELECT_ACTION_DIALOG_BUTTON_SEND_MESSAGE, Messages.XMPPHyperlink_SELECT_ACTION_DIALOG_BUTTON_CONNECT, Messages.XMPPHyperlink_SELECT_ACTION_DIALOG_BUTTON_CANCEL}, 2);
                    int selected = messageDialog.open();
                    switch (selected) {
                        case 0: {
                            this.openMessagesView(chatManager, (ID)localID, (ID)targetID, targetID.getUsername());
                            return;
                        }
                        case 1: {
                            super.open();
                            return;
                        }
                    }
                    return;
                }
                this.openMessagesView(chatManager, (ID)localID, (ID)targetID, targetID.getUsername());
            }
            catch (Exception e) {
                MessageDialog.openError(null, (String)Messages.XMPPHyperlink_ERROR_OPEN_MESSAGE_VIEW_DIALOG_TITLE, (String)NLS.bind((String)Messages.XMPPHyperlink_ERROR_OPEN_MESSAGE_VIEW_DIALOG_MESSAGE, (Object)e.getLocalizedMessage()));
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.provider.xmpp.ui", 4, Messages.XMPPHyperlink_ERROR_OPEN_MESSAGE_VIEW_LOG_STATUS_MESSAGE, (Throwable)e));
            }
        }
    }

    public XMPPHyperlink(IRegion region, URI uri) {
        super(region, uri);
    }

    protected IConnectWizard createConnectWizard() {
        String auth = this.getURI().getAuthority();
        if (this.isXMPPS) {
            return new XMPPSConnectWizard(auth);
        }
        return new XMPPConnectWizard(auth);
    }

    protected IContainer createContainer() throws ContainerCreateException {
        return ContainerFactory.getDefault().createContainer(this.isXMPPS ? ECF_XMPPS_CONTAINER_NAME : ECF_XMPP_CONTAINER_NAME);
    }
}

