/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorHelper {
    IWorkbenchWindow window = null;

    public EditorHelper(IWorkbenchWindow window) {
        this.window = window;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.window;
    }

    public IEditorPart openEditorForFile(IFile file) throws PartInitException {
        FileEditorInput input;
        IWorkbenchPage page = this.getWorkbenchWindow().getActivePage();
        IEditorPart part = page.findEditor((IEditorInput)(input = new FileEditorInput(file)));
        if (part != null) {
            page.activate((IWorkbenchPart)part);
        } else {
            String editorId = this.getEditorIdForFile(file);
            part = page.openEditor((IEditorInput)input, editorId);
        }
        return part;
    }

    protected ITextEditor openTextEditorForFile(IFile file) throws PartInitException {
        IEditorPart editor = this.openEditorForFile(file);
        if (editor != null && editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        return null;
    }

    public void openAndSelectForFile(IFile file, int offset, int length) throws PartInitException {
        ITextEditor textEditor = this.openTextEditorForFile(file);
        if (textEditor == null) {
            return;
        }
        this.setTextEditorSelection(textEditor, offset, length);
    }

    protected IMarker createMarkerForFile(IFile file, EclipseCollabSharedObject.SharedMarker marker) throws CoreException {
        IMarker m = file.createMarker("org.eclipse.ecf.example.collab.sharedmarker");
        m.setAttribute("severity", 0);
        Integer offset = marker.getOffset();
        Integer length = marker.getLength();
        int start = offset == null ? 0 : marker.getOffset();
        m.setAttribute("charStart", start);
        int end = start + (length == null ? 0 : marker.getOffset());
        m.setAttribute("charEnd", end);
        return m;
    }

    public void openAndAddMarkerForFile(IFile file, EclipseCollabSharedObject.SharedMarker marker) throws PartInitException, CoreException {
        FileEditorInput input;
        IWorkbenchPage page = this.getWorkbenchWindow().getActivePage();
        IEditorPart part = page.findEditor((IEditorInput)(input = new FileEditorInput(file)));
        if (part != null) {
            page.activate((IWorkbenchPart)part);
        } else {
            String editorId = this.getEditorIdForFile(file);
            part = page.openEditor((IEditorInput)input, editorId);
        }
        this.createMarkerForFile(file, marker);
    }

    protected void setTextEditorSelection(ITextEditor textEditor, int offset, int length) {
        textEditor.selectAndReveal(offset, length);
    }

    protected String getEditorIdForFile(IFile file) {
        IWorkbench wb = this.getWorkbenchWindow().getWorkbench();
        IEditorRegistry er = wb.getEditorRegistry();
        IEditorDescriptor desc = er.getDefaultEditor(file.getName());
        if (desc != null) {
            return desc.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }
}

