/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.recipes.helper;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.runtime.rete.recipes.ExpressionDefinition;
import org.eclipse.viatra.query.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesFactory;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;

public class RecipesHelper {
    private static final RecipesFactory FACTORY = RecipesFactory.eINSTANCE;

    private RecipesHelper() {
    }

    public static Mask mask(int sourceArity, Collection<Integer> sourceIndices) {
        Mask mask = FACTORY.createMask();
        mask.setSourceArity(sourceArity);
        mask.getSourceIndices().addAll(sourceIndices);
        return mask;
    }

    public static Mask mask(int sourceArity, int ... sourceIndices) {
        Mask mask = FACTORY.createMask();
        mask.setSourceArity(sourceArity);
        EList<Integer> maskIndeces = mask.getSourceIndices();
        int[] nArray = sourceIndices;
        int n = sourceIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            maskIndeces.add((Object)index);
            ++n2;
        }
        return mask;
    }

    public static ProjectionIndexerRecipe projectionIndexerRecipe(ReteNodeRecipe parent, Mask mask) {
        ProjectionIndexerRecipe recipe = FACTORY.createProjectionIndexerRecipe();
        recipe.setParent(parent);
        recipe.setMask(mask);
        return recipe;
    }

    public static ExpressionDefinition expressionDefinition(Object evaluator) {
        ExpressionDefinition definition = FACTORY.createExpressionDefinition();
        definition.setEvaluator(evaluator);
        return definition;
    }

    public static InputRecipe inputRecipe(Object inputKey, String inputKeyID, int arity) {
        InputRecipe recipe = FACTORY.createInputRecipe();
        recipe.setInputKey(inputKey);
        recipe.setKeyArity(arity);
        recipe.setKeyID(inputKeyID);
        recipe.setTraceInfo(inputKeyID);
        return recipe;
    }

    public static InputFilterRecipe inputFilterRecipe(ReteNodeRecipe parent, Object inputKey, String inputKeyID, Mask mask) {
        InputFilterRecipe it = FACTORY.createInputFilterRecipe();
        it.setParent(parent);
        it.setInputKey(inputKey);
        it.setKeyID(inputKeyID);
        it.setTraceInfo(inputKeyID);
        it.setMask(mask);
        return it;
    }
}

