/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl;

import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;

public class VariableBindingBasedCostFunction
implements ICostFunction {
    private static int MAX = 1000;
    private static int exportedParameterCost = MAX - 20;
    private static int binaryTransitiveClosureCost = MAX - 50;
    private static int nacCost = MAX - 100;
    private static int aggregatorCost = MAX - 200;
    private static int constantCost = 0;

    @Override
    public double apply(IConstraintEvaluationContext input) {
        PConstraint constraint = input.getConstraint();
        Set affectedVariables = constraint.getAffectedVariables();
        int cost = 0;
        if (constraint instanceof ConstantValue) {
            cost = constantCost;
        } else if (constraint instanceof BinaryTransitiveClosure) {
            cost = binaryTransitiveClosureCost;
        } else if (constraint instanceof NegativePatternCall) {
            cost = nacCost;
        } else if (constraint instanceof AggregatorConstraint) {
            cost = aggregatorCost;
        } else if (constraint instanceof ExportedParameter) {
            cost = exportedParameterCost;
        } else {
            for (PVariable pVariable : affectedVariables) {
                if (!input.getFreeVariables().contains(pVariable)) continue;
                ++cost;
            }
            if (cost == affectedVariables.size()) {
                cost *= 2;
            }
        }
        return Float.valueOf(cost).floatValue();
    }
}

