/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.colors;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSetting;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSettingsXML;
import org.eclipse.tracecompass.tmf.ui.views.colors.IColorSettingsListener;

public class ColorSettingsManager {
    private static final String COLOR_SETTINGS_FILE_NAME = "color_settings.xml";
    private static final String COLOR_SETTINGS_PATH_NAME;
    private static final IPath COLOR_SETTINGS_PATH_NAME_LEGACY;
    private static final ColorSetting DEFAULT_COLOR_SETTING;
    public static final int PRIORITY_NONE = Integer.MAX_VALUE;
    private static ColorSetting[] fColorSettings;
    private static List<IColorSettingsListener> fListeners;

    static {
        ColorSetting[] colorSettings;
        File legacyFileCore;
        COLOR_SETTINGS_PATH_NAME = Activator.getDefault().getStateLocation().addTrailingSeparator().append(COLOR_SETTINGS_FILE_NAME).toString();
        COLOR_SETTINGS_PATH_NAME_LEGACY = Activator.getDefault().getStateLocation().removeLastSegments(1).append("org.eclipse.linuxtools.tmf.ui").append(COLOR_SETTINGS_FILE_NAME);
        DEFAULT_COLOR_SETTING = new ColorSetting(null, null, null, null);
        File defaultFile = new File(COLOR_SETTINGS_PATH_NAME);
        if (!defaultFile.exists() && (legacyFileCore = COLOR_SETTINGS_PATH_NAME_LEGACY.toFile()).exists() && (colorSettings = ColorSettingsXML.load(COLOR_SETTINGS_PATH_NAME_LEGACY.toString())) != null) {
            ColorSettingsXML.save(COLOR_SETTINGS_PATH_NAME, colorSettings);
        }
        fColorSettings = ColorSettingsXML.load(COLOR_SETTINGS_PATH_NAME);
        fListeners = new ArrayList<IColorSettingsListener>();
    }

    public static ColorSetting[] getColorSettings() {
        return fColorSettings != null ? Arrays.copyOf(fColorSettings, fColorSettings.length) : null;
    }

    public static void setColorSettings(ColorSetting[] colorSettings) {
        ColorSetting[] colorSettingArray = fColorSettings = colorSettings != null ? Arrays.copyOf(colorSettings, colorSettings.length) : null;
        if (fColorSettings != null) {
            ColorSettingsXML.save(COLOR_SETTINGS_PATH_NAME, fColorSettings);
        }
        ColorSettingsManager.fireColorSettingsChanged();
    }

    public static ColorSetting getColorSetting(ITmfEvent event) {
        int i = 0;
        while (i < fColorSettings.length) {
            ColorSetting colorSetting = fColorSettings[i];
            ITmfFilterTreeNode filter = colorSetting.getFilter();
            if (filter != null && filter.matches(event)) {
                return colorSetting;
            }
            ++i;
        }
        return DEFAULT_COLOR_SETTING;
    }

    public static int getColorSettingPriority(ITmfEvent event) {
        int i = 0;
        while (i < fColorSettings.length) {
            ColorSetting colorSetting = fColorSettings[i];
            ITmfFilterTreeNode filter = colorSetting.getFilter();
            if (filter != null && filter.matches(event)) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public static ColorSetting getColorSetting(int priority) {
        if (priority < fColorSettings.length) {
            return fColorSettings[priority];
        }
        return DEFAULT_COLOR_SETTING;
    }

    public static void addColorSettingsListener(IColorSettingsListener listener) {
        if (!fListeners.contains(listener)) {
            fListeners.add(listener);
        }
    }

    public static void removeColorSettingsListener(IColorSettingsListener listener) {
        fListeners.remove(listener);
    }

    private static void fireColorSettingsChanged() {
        for (IColorSettingsListener listener : fListeners) {
            listener.colorSettingsChanged(fColorSettings);
        }
    }
}

