/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.websocket;

import java.io.IOException;
import java.util.logging.Logger;
import javax.websocket.Session;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;

public class WebSocketMessageConsumer
implements MessageConsumer {
    private static final Logger LOG = Logger.getLogger(WebSocketMessageConsumer.class.getName());
    private final Session session;
    private final MessageJsonHandler jsonHandler;

    public WebSocketMessageConsumer(Session session, MessageJsonHandler jsonHandler) {
        this.session = session;
        this.jsonHandler = jsonHandler;
    }

    public Session getSession() {
        return this.session;
    }

    public void consume(Message message) {
        String content = this.jsonHandler.serialize(message);
        try {
            this.sendMessage(content);
        }
        catch (IOException exception) {
            throw new JsonRpcException((Throwable)exception);
        }
    }

    protected void sendMessage(String message) throws IOException {
        if (this.session.isOpen()) {
            int length = message.length();
            if (length <= this.session.getMaxTextMessageBufferSize()) {
                this.session.getAsyncRemote().sendText(message);
            } else {
                int currentOffset = 0;
                while (currentOffset < length) {
                    int currentEnd = Math.min(currentOffset + this.session.getMaxTextMessageBufferSize(), length);
                    this.session.getBasicRemote().sendText(message.substring(currentOffset, currentEnd), currentEnd == length);
                    currentOffset = currentEnd;
                }
            }
        } else {
            LOG.info("Ignoring message due to closed session: " + message);
        }
    }
}

