/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.jobs.FindImageInfoRunnable;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerDataVolumeDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerEnvironmentVariableDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerLabelVariableDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DataVolumeModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.EnvironmentVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.LabelVariableModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImageRunResourceVolumesVariablesPage
extends WizardPage {
    private final int COLUMNS = 2;
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunResourceVolumesVariablesModel model;
    private final ILaunchConfiguration lastLaunchConfiguration;

    public ImageRunResourceVolumesVariablesPage(IDockerConnection connection) throws DockerException {
        super("ImageSelectionPage2", WizardMessages.getString("ImageRunResourceVolVarPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setPageComplete(true);
        this.model = new ImageRunResourceVolumesVariablesModel(connection);
        this.lastLaunchConfiguration = null;
    }

    public ImageRunResourceVolumesVariablesPage(IDockerImage image, ILaunchConfiguration lastLaunchConfiguration) throws DockerException {
        super("ImageSelectionPage2", WizardMessages.getString("ImageRunResourceVolVarPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setPageComplete(true);
        this.model = new ImageRunResourceVolumesVariablesModel(image);
        this.lastLaunchConfiguration = lastLaunchConfiguration;
    }

    public ImageRunResourceVolumesVariablesModel getModel() {
        return this.model;
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createVolumeSettingsContainer(container);
        this.createEnvironmentVariablesContainer(container);
        this.createLabelVariablesContainer(container);
        this.createSectionSeparator(container, true);
        this.createResourceSettingsContainer(container);
        this.setDefaultValues();
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)scrollTop);
    }

    private void createSectionSeparator(Composite container, boolean separator) {
        int SECTION_INDENT = 10;
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).indent(-1, 10).applyTo((Control)new Label(container, separator ? 258 : 0));
    }

    private void createResourceSettingsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().spacing(10, 2).applyTo(container);
        Button enableResourceLimitationButton = new Button(container, 32);
        enableResourceLimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.enableLimitationButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)enableResourceLimitationButton);
        int COLUMNS = 5;
        int INDENT = 20;
        Composite subContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).indent(20, 0).span(5, 1).grab(true, false).applyTo((Control)subContainer);
        GridLayoutFactory.fillDefaults().numColumns(5).margins(6, 6).spacing(10, 2).applyTo(subContainer);
        Label cpuPriorityLabel = new Label(subContainer, 0);
        cpuPriorityLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.cpuPriorityLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)cpuPriorityLabel);
        Button lowCPULimitationButton = new Button(subContainer, 16);
        this.bindButton(lowCPULimitationButton, 512L);
        lowCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.lowButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lowCPULimitationButton);
        Button mediumCPULimitationButton = new Button(subContainer, 16);
        mediumCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.mediumButton"));
        this.bindButton(mediumCPULimitationButton, 1024L);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)mediumCPULimitationButton);
        Button highCPULimitationButton = new Button(subContainer, 16);
        highCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.highButton"));
        this.bindButton(highCPULimitationButton, 2048L);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)highCPULimitationButton);
        Label memoryLimitLabel = new Label(subContainer, 0);
        memoryLimitLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.memoryLimit"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)memoryLimitLabel);
        Scale memoryLimitSpinner = new Scale(subContainer, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(2, 1).applyTo((Control)memoryLimitSpinner);
        memoryLimitSpinner.setBackground(Display.getDefault().getSystemColor(37));
        memoryLimitSpinner.setMinimum(0);
        memoryLimitSpinner.setMaximum(this.model.getTotalMemory());
        memoryLimitSpinner.setPageIncrement(64);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)memoryLimitSpinner), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"memoryLimit").observe((Object)this.model));
        Text memoryLimitValueText = new Text(subContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(50, -1).applyTo((Control)memoryLimitValueText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)memoryLimitValueText), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"memoryLimit").observe((Object)this.model));
        Label memoryLimitValueLabel = new Label(subContainer, 0);
        memoryLimitValueLabel.setText("MB");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)memoryLimitValueLabel);
        IObservableValue enableResourceLimitationsObservable = BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"enableResourceLimitations").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)enableResourceLimitationButton), enableResourceLimitationsObservable);
        enableResourceLimitationsObservable.addChangeListener(this.onEnableResourceLimitation(subContainer));
        this.toggleResourceLimitationControls(subContainer);
    }

    private Binding bindButton(Button button, final long cpuShares) {
        return this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)button), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"cpuShareWeight").observe((Object)this.model), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value.equals(Boolean.TRUE)) {
                    return cpuShares;
                }
                return 0L;
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                return value.equals(cpuShares);
            }
        });
    }

    private IChangeListener onEnableResourceLimitation(Composite container) {
        return event -> this.toggleResourceLimitationControls(container);
    }

    private void toggleResourceLimitationControls(Composite container) {
        Control[] controlArray = container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control childControl = controlArray[n2];
            if (this.model.isEnableResourceLimitations()) {
                childControl.setEnabled(true);
            } else {
                childControl.setEnabled(false);
            }
            ++n2;
        }
    }

    private void createVolumeSettingsContainer(Composite container) {
        Label volumesLabel = new Label(container, 0);
        volumesLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.dataVolumesLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)volumesLabel);
        CheckboxTableViewer dataVolumesTableViewer = this.createVolumesTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(200, 100).applyTo((Control)dataVolumesTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.addButton"));
        addButton.addSelectionListener(this.onAddDataVolume(dataVolumesTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.editButton"));
        editButton.addSelectionListener(this.onEditDataVolume(dataVolumesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveDataVolumes((TableViewer)dataVolumesTableViewer));
        removeButton.setEnabled(false);
        this.bind((StructuredViewer)dataVolumesTableViewer, (IObservableList)this.model.getDataVolumes(), BeanProperties.values(DataVolumeModel.class, (String[])new String[]{"containerPath", "mount", "readOnly"}));
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)dataVolumesTableViewer, DataVolumeModel.class), BeanProperties.set((String)"selectedDataVolumes").observe((Object)this.model));
        dataVolumesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private void setDefaultValues() {
        try {
            IDockerImage selectedImage = this.model.getSelectedImage();
            if (selectedImage == null) {
                return;
            }
            IDockerImageInfo selectedImageInfo = this.findImageInfo(selectedImage);
            HashMap<String, DataVolumeModel> volumes = new HashMap<String, DataVolumeModel>();
            HashSet<DataVolumeModel> selectedVolumes = new HashSet<DataVolumeModel>();
            if (selectedImageInfo != null && selectedImageInfo.config() != null) {
                for (String volume : selectedImageInfo.config().volumes().keySet()) {
                    volumes.put(volume, new DataVolumeModel(volume));
                }
            }
            if (this.lastLaunchConfiguration != null) {
                List launchConfigVolumes = this.lastLaunchConfiguration.getAttribute("volumes", Collections.emptyList());
                for (String containerVolume : launchConfigVolumes) {
                    DataVolumeModel volume = DataVolumeModel.parseString(containerVolume);
                    if (volume == null) continue;
                    volumes.put(volume.getContainerPath(), volume);
                    selectedVolumes.add(volume);
                }
                this.model.setEnvironmentVariables(this.lastLaunchConfiguration.getAttribute("envVariables", Collections.emptyList()));
                Map labels = this.lastLaunchConfiguration.getAttribute("labels", null);
                if (labels != null) {
                    this.model.setLabelVariables(labels);
                }
                this.model.setEnableResourceLimitations(this.lastLaunchConfiguration.getAttribute("enableLimits", false));
                this.model.setCpuShareWeight(Long.parseLong(this.lastLaunchConfiguration.getAttribute("cpuPriority", Long.toString(1024L))));
                long memoryLimit = Long.parseLong(this.lastLaunchConfiguration.getAttribute("memoryLimit", Long.toString(512L)));
                this.model.setMemoryLimit(Math.min((long)this.model.getTotalMemory(), memoryLimit));
            }
            this.model.setDataVolumes(volumes.values());
            this.model.setSelectedDataVolumes(selectedVolumes);
        }
        catch (InterruptedException | InvocationTargetException | CoreException e) {
            Activator.log(e);
        }
    }

    private IDockerImageInfo findImageInfo(IDockerImage selectedImage) throws InvocationTargetException, InterruptedException {
        FindImageInfoRunnable findImageInfoRunnable = new FindImageInfoRunnable(selectedImage);
        this.getContainer().run(true, true, (IRunnableWithProgress)findImageInfoRunnable);
        IDockerImageInfo selectedImageInfo = findImageInfoRunnable.getResult();
        return selectedImageInfo;
    }

    private void bind(StructuredViewer viewer, IObservableList input, IBeanValueProperty[] labelProperties) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new DataVolumesLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput((Object)input);
        }
    }

    private ISelectionChangedListener onSelectionChanged(Button ... targetButtons) {
        return e -> {
            if (e.getSelection().isEmpty()) {
                ImageRunResourceVolumesVariablesPage.setControlsEnabled((Control[])targetButtons, false);
            } else {
                ImageRunResourceVolumesVariablesPage.setControlsEnabled((Control[])targetButtons, true);
            }
        };
    }

    private SelectionListener onAddDataVolume(CheckboxTableViewer dataVolumesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(this.getShell(), this.model.getConnection());
            dialog.create();
            if (dialog.open() == 0) {
                DataVolumeModel dataVolume = dialog.getDataVolume();
                dataVolume.setSelected(true);
                this.model.getDataVolumes().add((Object)dataVolume);
                this.model.getSelectedDataVolumes().add(dataVolume);
                dataVolumesTableViewer.setChecked((Object)dataVolume, true);
            }
        });
    }

    private SelectionListener onEditDataVolume(CheckboxTableViewer dataVolumesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = (IStructuredSelection)dataVolumesTableViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            DataVolumeModel selectedDataVolume = (DataVolumeModel)selection.getFirstElement();
            ContainerDataVolumeDialog dialog = new ContainerDataVolumeDialog(this.getShell(), this.model.getConnection(), selectedDataVolume);
            dialog.create();
            if (dialog.open() == 0) {
                DataVolumeModel dialogDataVolume = dialog.getDataVolume();
                selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                selectedDataVolume.setMountType(dialogDataVolume.getMountType());
                selectedDataVolume.setHostPathMount(dialogDataVolume.getHostPathMount());
                selectedDataVolume.setContainerMount(dialogDataVolume.getContainerMount());
                selectedDataVolume.setReadOnly(dialogDataVolume.isReadOnly());
                this.model.getSelectedDataVolumes().add(selectedDataVolume);
                dataVolumesTableViewer.setChecked((Object)selectedDataVolume, true);
            }
        });
    }

    private SelectionListener onRemoveDataVolumes(TableViewer dataVolumesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = dataVolumesTableViewer.getStructuredSelection();
            for (DataVolumeModel volume : selection) {
                this.model.removeDataVolume(volume);
                this.model.getSelectedDataVolumes().remove(volume);
            }
        });
    }

    private CheckboxTableViewer createVolumesTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.dbc.bindSet((IObservableSet)ViewersObservables.observeCheckedElements((CheckboxTableViewer)tableViewer, DataVolumeModel.class), BeanProperties.set((String)"selectedDataVolumes").observe((Object)this.model));
        this.addTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.containerPathColumn"), 150);
        this.addTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.mountColumn"), 150);
        this.addTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.readonlyColumn"), 60);
        return tableViewer;
    }

    private TableViewerColumn addTableViewerColum(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private void createLabelVariablesContainer(Composite container) {
        Label labelVarLabel = new Label(container, 0);
        labelVarLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.labelVarLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)labelVarLabel);
        TableViewer labelVariablesTableViewer = this.createEnvironmentVariablesTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(200, 100).applyTo((Control)labelVariablesTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.addButton"));
        addButton.setEnabled(true);
        addButton.addSelectionListener(this.onAddLabelVariable());
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.editButton"));
        editButton.setEnabled(true);
        editButton.addSelectionListener(this.onEditLabelVariable(labelVariablesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveLabelVariables(labelVariablesTableViewer));
        removeButton.setEnabled(false);
        ViewerSupport.bind((StructuredViewer)labelVariablesTableViewer, this.model.getLabelVariables(), (IValueProperty[])BeanProperties.values(LabelVariableModel.class, (String[])new String[]{"name", "value"}));
        labelVariablesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private SelectionListener onAddLabelVariable() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerLabelVariableDialog dialog = new ContainerLabelVariableDialog(this.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                this.model.getLabelVariables().add((Object)dialog.getLabelVariable());
            }
        });
    }

    private SelectionListener onEditLabelVariable(TableViewer LabelVariablesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            LabelVariableModel selectedVariable = (LabelVariableModel)LabelVariablesTableViewer.getStructuredSelection().getFirstElement();
            ContainerLabelVariableDialog dialog = new ContainerLabelVariableDialog(this.getShell(), selectedVariable);
            dialog.create();
            if (dialog.open() == 0) {
                selectedVariable.setName(dialog.getLabelVariable().getName());
                selectedVariable.setValue(dialog.getLabelVariable().getValue());
                LabelVariablesTableViewer.refresh();
            }
        });
    }

    private SelectionListener onRemoveLabelVariables(TableViewer linksTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = linksTableViewer.getStructuredSelection();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.model.removeLabelVariable((LabelVariableModel)iterator.next());
            }
        });
    }

    private void createEnvironmentVariablesContainer(Composite container) {
        Label envVarLabel = new Label(container, 0);
        envVarLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.envVarLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)envVarLabel);
        TableViewer environmentVariablesTableViewer = this.createEnvironmentVariablesTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(200, 100).applyTo((Control)environmentVariablesTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.addButton"));
        addButton.setEnabled(true);
        addButton.addSelectionListener(this.onAddEnvironmentVariable());
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.editButton"));
        editButton.setEnabled(true);
        editButton.addSelectionListener(this.onEditEnvironmentVariable(environmentVariablesTableViewer));
        editButton.setEnabled(false);
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.removeButton"));
        removeButton.addSelectionListener(this.onRemoveEnvironmentVariables(environmentVariablesTableViewer));
        removeButton.setEnabled(false);
        ViewerSupport.bind((StructuredViewer)environmentVariablesTableViewer, this.model.getEnvironmentVariables(), (IValueProperty[])BeanProperties.values(EnvironmentVariableModel.class, (String[])new String[]{"name", "value"}));
        environmentVariablesTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private TableViewer createEnvironmentVariablesTable(Composite container) {
        Table table = new Table(container, 68352);
        TableViewer tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addTableViewerColum(tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.nameColumn"), 200);
        this.addTableViewerColum(tableViewer, WizardMessages.getString("ImageRunResourceVolVarPage.valueColumn"), 200);
        return tableViewer;
    }

    private SelectionListener onAddEnvironmentVariable() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerEnvironmentVariableDialog dialog = new ContainerEnvironmentVariableDialog(this.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                this.model.getEnvironmentVariables().add((Object)dialog.getEnvironmentVariable());
            }
        });
    }

    private SelectionListener onEditEnvironmentVariable(TableViewer environmentVariablesTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            EnvironmentVariableModel selectedVariable = (EnvironmentVariableModel)environmentVariablesTableViewer.getStructuredSelection().getFirstElement();
            ContainerEnvironmentVariableDialog dialog = new ContainerEnvironmentVariableDialog(this.getShell(), selectedVariable);
            dialog.create();
            if (dialog.open() == 0) {
                selectedVariable.setName(dialog.getEnvironmentVariable().getName());
                selectedVariable.setValue(dialog.getEnvironmentVariable().getValue());
                environmentVariablesTableViewer.refresh();
            }
        });
    }

    private SelectionListener onRemoveEnvironmentVariables(TableViewer linksTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = linksTableViewer.getStructuredSelection();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.model.removeEnvironmentVariable((EnvironmentVariableModel)iterator.next());
            }
        });
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    private static final class DataVolumesLabelProvider
    extends ObservableMapLabelProvider {
        private Image CONTAINER_IMAGE = SWTImagesFactory.DESC_CONTAINER.createImage();
        private Image FOLDER_CLOSED_IMAGE = SWTImagesFactory.DESC_FOLDER_CLOSED.createImage();
        private Image FILE_IMAGE = SWTImagesFactory.DESC_FILE.createImage();

        public DataVolumesLabelProvider(IObservableMap[] attributeMaps) {
            super(attributeMaps);
        }

        public void dispose() {
            this.CONTAINER_IMAGE.dispose();
            this.FOLDER_CLOSED_IMAGE.dispose();
            this.FILE_IMAGE.dispose();
            super.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            if (dataVolume.getMountType() != null && columnIndex == 1) {
                switch (dataVolume.getMountType()) {
                    case CONTAINER: {
                        return this.CONTAINER_IMAGE;
                    }
                    case HOST_FILE_SYSTEM: {
                        File hostFile = new File(dataVolume.getMount());
                        if (!hostFile.exists() || hostFile.isDirectory()) {
                            return this.FOLDER_CLOSED_IMAGE;
                        }
                        return this.FILE_IMAGE;
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DataVolumeModel dataVolume = (DataVolumeModel)element;
            switch (columnIndex) {
                case 0: {
                    return dataVolume.getContainerPath();
                }
                case 1: {
                    return dataVolume.getMount();
                }
                case 2: {
                    if (dataVolume.getMountType() != ImageRunResourceVolumesVariablesModel.MountType.HOST_FILE_SYSTEM) {
                        return null;
                    }
                    if (dataVolume.isReadOnly()) {
                        return WizardMessages.getString("ImageRunResourceVolVarPage.true");
                    }
                    return WizardMessages.getString("ImageRunResourceVolVarPage.false");
                }
            }
            return null;
        }
    }
}

