/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view.actions;

import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ActionsMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopySelectedMessagesAction
extends Action {
    private Clipboard clipboard;
    private TableViewer tableViewer;

    public CopySelectedMessagesAction(TableViewer tableViewer, Clipboard clipboard) {
        super(ActionsMessages.CopySelectedMessagesAction_text);
        this.setToolTipText(ActionsMessages.CopySelectedMessagesAction_tooltip);
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.tableViewer = tableViewer;
        this.clipboard = clipboard;
    }

    public void run() {
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.tableViewer.getLabelProvider();
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean needEOL = false;
            for (Object item : selection) {
                if (needEOL) {
                    sb.append(System.getProperty("line.separator"));
                } else {
                    needEOL = true;
                }
                sb.append(labelProvider.getColumnText(item, 0));
            }
            this.clipboard.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }
}

