/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDLabelDirectEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.BoxComponentFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.ColumnData;

public abstract class AbstractBoxtEditPart
extends BaseEditPart
implements INamedEditPart {
    protected ColumnData columnData = new ColumnData();
    protected BoxComponentFigure figure;
    private DirectEditManager manager;

    protected IFigure createFigure() {
        this.figure = new BoxComponentFigure();
        this.figure.setBorder((Border)new LineBorder(1));
        ToolbarLayout toolbarLayout = new ToolbarLayout();
        toolbarLayout.setStretchMinorAxis(true);
        this.figure.setLayoutManager((LayoutManager)toolbarLayout);
        return this.figure;
    }

    public IFigure getContentPane() {
        return this.figure.getContentPane();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ASDLabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    public void performDirectEdit(Point cursorLocation) {
        if (!this.isFileReadOnly() && (cursorLocation == null || this.hitTestFigure(this.figure.getHeadingFigure(), cursorLocation) && !this.isReadOnly())) {
            this.manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, cursorLocation));
            this.manager.show();
        } else if ((this.hitTest(this.figure.getLabel(), cursorLocation) || this.hitTestFigure(this.figure.getHeadingFigure(), cursorLocation)) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            Point location = null;
            if (req instanceof DirectEditRequest) {
                location = ((DirectEditRequest)req).getLocation();
            }
            this.performDirectEdit(location);
        }
    }

    public Label getLabelFigure() {
        return this.figure.getLabel();
    }

    protected void refreshChildren() {
        super.refreshChildren();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        WSDLBaseAdapter box = (WSDLBaseAdapter)this.getModel();
        this.figure.headingFigure.setIsReadOnly(box.isReadOnly());
        this.figure.getLabel().setText(box.getName());
    }

    public void addFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(2);
        this.figure.setSelected(true);
        this.figure.repaint();
    }

    public void removeFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(1);
        boxFigureLineBorder.setColor(DesignViewGraphicsConstants.defaultForegroundColor);
        this.figure.setSelected(false);
        this.figure.repaint();
    }

    public ColumnData getColumnData() {
        return this.columnData;
    }
}

