/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.concurrent;

import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.nls.Messages;

class MonitorTask
extends TimerTask {
    private long timeout;
    private long startTime;
    private ICallback callback;

    public MonitorTask(ICallback callback, long timeout) {
        this.callback = callback;
        this.timeout = timeout;
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ICallback iCallback = this.callback;
        synchronized (iCallback) {
            if (this.callback.isDone()) {
                this.cancel();
            } else if (System.currentTimeMillis() - this.startTime >= this.timeout) {
                this.cancel();
                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.MonitorTask_TimeoutError, (Throwable)new TimeoutException());
                this.callback.done((Object)this, (IStatus)status);
            }
        }
    }
}

