/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards.registries;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.ui.wizards.registries.IRSEWizardRegistryElement;
import org.eclipse.rse.ui.wizards.registries.RSEWizardCategory;
import org.eclipse.rse.ui.wizards.registries.RSEWizardRegistryElement;

public abstract class RSEAbstractWizardRegistry {
    private final Map elements = new LinkedHashMap();
    private boolean isInitialized = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.wizards.registries.RSEAbstractWizardRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected void initialize() {
        this.elements.clear();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.getExtensionPointId());
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element != null) {
                this.internalCreateRegistryElementFor(element);
            }
            ++i;
        }
        this.isInitialized = true;
    }

    private void internalCreateRegistryElementFor(IConfigurationElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        IRSEWizardRegistryElement wizardElement = this.createWizardRegistryElementFor(element);
        if (wizardElement != null && wizardElement.isValid() && !this.elements.containsKey(wizardElement.getId())) {
            this.elements.put(wizardElement.getId(), wizardElement);
        } else if (wizardElement != null && wizardElement.isValid()) {
            String message = "Wizard element contribution skipped. Non-unique element id (plugin: {0}, extension point: {1}, id: {2}, element name: {3}).";
            message = MessageFormat.format(message, element.getContributor().getName(), this.getExtensionPointId(), wizardElement.getId(), element.getName());
            RSECorePlugin.getDefault().getLogger().logWarning(message);
        } else if (wizardElement != null) {
            String message = "Wizard element contribution skipped. Invalid or incomplete (plugin: {0}, extension point: {1}, id: {2}, element name: {3}).";
            message = MessageFormat.format(message, element.getContributor().getName(), this.getExtensionPointId(), wizardElement.getId(), element.getName());
            RSECorePlugin.getDefault().getLogger().logWarning(message);
        } else {
            String message = "Wizard contribution skipped. Failed to create wizard descriptor (plugin: {0}, extension point: {1}, extension: {2}).";
            message = MessageFormat.format(message, element.getContributor().getName(), this.getExtensionPointId(), element.getDeclaringExtension().getLabel());
            RSECorePlugin.getDefault().getLogger().logWarning(message);
        }
    }

    protected final boolean isInitialized() {
        return this.isInitialized;
    }

    protected abstract String getExtensionPointId();

    protected IRSEWizardRegistryElement createWizardRegistryElementFor(IConfigurationElement element) {
        RSEWizardCategory wizardElement = null;
        if ("category".equals(element.getName())) {
            wizardElement = new RSEWizardCategory(this, element);
        }
        if (wizardElement == null) {
            new RSEWizardRegistryElement(this, element);
        }
        return wizardElement;
    }

    public IRSEWizardRegistryElement[] getElements() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        return this.elements.values().toArray(new IRSEWizardRegistryElement[this.elements.values().size()]);
    }

    public IRSEWizardRegistryElement findElementById(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        IRSEWizardRegistryElement[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            if (id.equals(elements[i].getId())) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }
}

