/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.messages;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rse.services.clientserver.messages.IndicatorException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;

public class SystemUIMessage
extends SystemMessage {
    protected static final int displayMask = 7;

    public SystemUIMessage(String comp, String sub, String number, char ind, String l1, String l2) throws IndicatorException {
        super(comp, sub, number, ind, l1, l2);
    }

    public String getSubValue(Object sub) {
        if (sub == null) {
            return "";
        }
        if (sub instanceof IStatus) {
            return SystemUIMessage.populateList("", (IStatus)sub);
        }
        return super.getSubValue(sub);
    }

    private static String populateList(String list, IStatus status) {
        List<IStatus> statusList = Arrays.asList(status.getChildren());
        Iterator<IStatus> enumer = statusList.iterator();
        while (enumer.hasNext()) {
            IStatus childStatus = enumer.next();
            list = SystemUIMessage.populateList(list, childStatus, 0);
        }
        return list;
    }

    private static String populateList(String list, IStatus status, int nesting) {
        if (!status.matches(7)) {
            return list;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            sb.append("  ");
            ++i;
        }
        sb.append(status.getMessage());
        list = String.valueOf(list) + sb.toString() + "\n";
        IStatus[] children = status.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            list = SystemUIMessage.populateList(list, children[i2], nesting + 1);
            ++i2;
        }
        return list;
    }
}

