/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core;

import org.eclipse.photran.internal.core.Messages;
import org.eclipse.photran.internal.core.lexer.FileOrIFile;
import org.eclipse.photran.internal.core.lexer.Token;

public class SyntaxException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Token lookahead;

    public SyntaxException(Token lookahead, String expectedTerminals) {
        super(Messages.bind((String)Messages.SyntaxException_Message, (Object[])new Object[]{lookahead.getTerminal().toString(), lookahead.getPhysicalFile(), lookahead.getLine(), lookahead.getCol(), expectedTerminals}));
        this.lookahead = lookahead;
    }

    public FileOrIFile getFile() {
        return this.lookahead.getPhysicalFile();
    }

    public int getTokenLine() {
        return this.lookahead.getLine();
    }

    public int getTokenColumn() {
        return this.lookahead.getCol();
    }

    public int getTokenOffset() {
        return Math.max(0, this.lookahead.getFileOffset());
    }

    public int getTokenLength() {
        return Math.max(0, this.lookahead.getLength());
    }
}

