/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.oclany;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.library.AbstractUntypedBinaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class OclElementOclAsModelTypeOperation
extends AbstractUntypedBinaryOperation {
    public static final @NonNull OclElementOclAsModelTypeOperation INSTANCE = new OclElementOclAsModelTypeOperation();

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @Nullable Object sourceVal, @Nullable Object argVal) {
        if (sourceVal instanceof InvalidValueException) {
            throw (InvalidValueException)sourceVal;
        }
        Type argType = OclElementOclAsModelTypeOperation.asType(argVal);
        Type sourceType = executor.getIdResolver().getDynamicTypeOf(sourceVal);
        if (sourceVal == null) {
            throw new InvalidValueException(PivotMessages.NullNavigation, "source value", "oclAsModelType");
        }
        Iterable<@NonNull Class> modelClasses = ((IdResolver.IdResolverExtension)executor.getIdResolver()).getModelClassesOf(sourceVal);
        if (modelClasses == null) {
            throw new InvalidValueException(PivotMessages.IncompatibleModelType, sourceType);
        }
        StandardLibrary standardLibrary = executor.getStandardLibrary();
        Class bestModelType = null;
        for (Class modelClass : modelClasses) {
            if (!argType.conformsTo(standardLibrary, modelClass)) continue;
            if (bestModelType == null) {
                bestModelType = modelClass;
                continue;
            }
            throw new InvalidValueException(PivotMessages.AmbiguousModelType, bestModelType, modelClass, sourceType);
        }
        if (bestModelType != null) {
            return sourceVal;
        }
        for (Class modelClass : modelClasses) {
            if (!modelClass.conformsTo(standardLibrary, argType)) continue;
            if (bestModelType == null) {
                bestModelType = modelClass;
                continue;
            }
            throw new InvalidValueException(PivotMessages.IncompatibleModelType, bestModelType, modelClass, sourceType);
        }
        if (bestModelType != null) {
            return sourceVal;
        }
        throw new InvalidValueException(PivotMessages.IncompatibleModelType, sourceType);
    }
}

