/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.internal.values.OrderedSetValueImpl;
import org.eclipse.ocl.pivot.internal.values.RangeSequenceValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseOrderedSetValueImpl;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.Value;

public class RangeOrderedSetValueImpl
extends OrderedSetValueImpl {
    public RangeOrderedSetValueImpl(@NonNull CollectionTypeId typeId, @NonNull IntegerRange range) {
        super(typeId, range);
    }

    @Override
    public @NonNull OrderedSetValue append(@Nullable Object value) {
        IntegerRange theElements = this.getElements();
        IntegerValue nextValue = theElements.getLast().addInteger(ONE_VALUE);
        if (nextValue.equals(value)) {
            IntegerRange range = RangeOrderedSetValueImpl.createRange(theElements.getFirst(), nextValue);
            return new RangeOrderedSetValueImpl(this.getTypeId(), range);
        }
        List<Object> elements = this.createElements();
        elements.remove(value);
        elements.add(value);
        return new SparseOrderedSetValueImpl(this.getTypeId(), elements);
    }

    @Override
    public @NonNull IntegerValue count(@Nullable Object value) {
        IntegerValue integerValue = ValueUtil.isIntegerValue(value);
        if (integerValue != null && this.elements.contains(integerValue)) {
            return ONE_VALUE;
        }
        return ZERO_VALUE;
    }

    protected List<Object> createElements() {
        ArrayList<Object> elements = new ArrayList<Object>(this.intSize());
        for (Object object : this.iterable()) {
            elements.add(object);
        }
        return elements;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RangeOrderedSetValueImpl) {
            RangeOrderedSetValueImpl that = (RangeOrderedSetValueImpl)obj;
            return this.elements.equals(that.elements);
        }
        return super.equals(obj);
    }

    @Override
    public @Nullable Value first() {
        return this.getElements().getFirst();
    }

    @Override
    public @NonNull OrderedSetValue flatten() {
        return this;
    }

    public @NonNull IntegerRange getElements() {
        return (IntegerRange)this.elements;
    }

    @Override
    public @NonNull OrderedSetValue including(@Nullable Object value) {
        return this.append(value);
    }

    @Override
    public @Nullable Value last() {
        return this.getElements().getLast();
    }

    @Override
    public @NonNull OrderedSetValue prepend(@Nullable Object value) {
        IntegerRange theElements = this.getElements();
        IntegerValue previousValue = theElements.getFirst().subtractInteger(ONE_VALUE);
        if (previousValue.equals(value)) {
            IntegerRange range = RangeOrderedSetValueImpl.createRange(previousValue, theElements.getLast());
            return new RangeOrderedSetValueImpl(this.getTypeId(), range);
        }
        List<Object> elements = this.createElements();
        elements.remove(value);
        elements.add(0, value);
        return new SparseOrderedSetValueImpl(this.getTypeId(), elements);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return new RangeSequenceValueImpl(this.getSequenceTypeId(), this.getElements());
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("OrderedSet{");
        IntegerRange theElements = this.getElements();
        s.append(theElements.getFirst());
        s.append("..");
        s.append(theElements.getLast());
        s.append("}");
        s.toString();
    }
}

