/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class EvaluationCache {
    public static final @NonNull TracingOption EVALUATIONS = new TracingOption("org.eclipse.ocl.pivot", "evaluations");
    protected final @NonNull Executor executor;
    private final @NonNull Map<@NonNull Integer, @NonNull Object> hashCode2evaluations = new HashMap<Integer, Object>();
    protected final boolean debugEvaluations = EVALUATIONS.isActive();

    public EvaluationCache(@NonNull Executor executor) {
        this.executor = executor;
    }

    public void dispose() {
        this.hashCode2evaluations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Object getCachedEvaluationResult(@NonNull LibraryOperation.LibraryOperationExtension2 implementation, @NonNull TypedElement caller, Object ... sourceAndArgumentValues) {
        Object sourceAndArgumentValue;
        @NonNull IdResolver.IdResolverExtension idResolver = (IdResolver.IdResolverExtension)this.executor.getIdResolver();
        int hashCode = implementation.hashCode();
        Object[] objectArray = sourceAndArgumentValues;
        int n = sourceAndArgumentValues.length;
        int n2 = 0;
        while (n2 < n) {
            sourceAndArgumentValue = objectArray[n2];
            hashCode = 3 * hashCode + idResolver.oclHashCode(sourceAndArgumentValue);
            ++n2;
        }
        sourceAndArgumentValue = this.hashCode2evaluations;
        synchronized (sourceAndArgumentValue) {
            Object zeroOrMoreEvaluations = this.hashCode2evaluations.get(hashCode);
            EvaluationResult oneEvaluation = null;
            if (zeroOrMoreEvaluations instanceof EvaluationResult) {
                oneEvaluation = (EvaluationResult)zeroOrMoreEvaluations;
                if (oneEvaluation.isEqual(idResolver, implementation, sourceAndArgumentValues)) {
                    if (this.debugEvaluations) {
                        EVALUATIONS.println("old:" + oneEvaluation);
                    }
                    return oneEvaluation.getResult();
                }
            } else if (zeroOrMoreEvaluations instanceof List) {
                @NonNull @NonNull List zeroOrMoreEvaluations2 = (List)zeroOrMoreEvaluations;
                for (EvaluationResult aEvaluation : zeroOrMoreEvaluations2) {
                    if (!aEvaluation.isEqual(idResolver, implementation, sourceAndArgumentValues)) continue;
                    if (this.debugEvaluations) {
                        EVALUATIONS.println("old:" + aEvaluation);
                    }
                    return aEvaluation.getResult();
                }
            }
        }
        Object result = implementation.basicEvaluate(this.executor, caller, sourceAndArgumentValues);
        EvaluationResult theEvaluation = new EvaluationResult(implementation, sourceAndArgumentValues, result);
        Map<Integer, Object> map = this.hashCode2evaluations;
        synchronized (map) {
            Object zeroOrMoreEvaluations = this.hashCode2evaluations.get(hashCode);
            if (zeroOrMoreEvaluations == null) {
                this.hashCode2evaluations.put(hashCode, theEvaluation);
            } else if (zeroOrMoreEvaluations instanceof EvaluationResult) {
                EvaluationResult oneEvaluation = (EvaluationResult)zeroOrMoreEvaluations;
                if (oneEvaluation.isEqual(idResolver, implementation, sourceAndArgumentValues)) {
                    if (this.debugEvaluations) {
                        EVALUATIONS.println("old:" + oneEvaluation);
                    }
                    return oneEvaluation.getResult();
                }
                ArrayList<@NonNull EvaluationResult> twoOrMoreEvaluations = new ArrayList<EvaluationResult>(4);
                twoOrMoreEvaluations.add(oneEvaluation);
                twoOrMoreEvaluations.add(theEvaluation);
                this.hashCode2evaluations.put(hashCode, twoOrMoreEvaluations);
            } else if (zeroOrMoreEvaluations instanceof List) {
                @NonNull @NonNull List twoOrMoreEvaluations = (List)zeroOrMoreEvaluations;
                for (EvaluationResult aEvaluation : twoOrMoreEvaluations) {
                    if (!aEvaluation.isEqual(idResolver, implementation, sourceAndArgumentValues)) continue;
                    if (this.debugEvaluations) {
                        EVALUATIONS.println("old:" + aEvaluation);
                    }
                    return aEvaluation.getResult();
                }
                twoOrMoreEvaluations.add(theEvaluation);
            }
            return theEvaluation.getResult();
        }
    }

    private static final class EvaluationResult {
        private final @NonNull LibraryOperation.LibraryOperationExtension2 implementation;
        private final @Nullable Object @NonNull [] theseValues;
        private final @Nullable Object result;

        public EvaluationResult(@NonNull LibraryOperation.LibraryOperationExtension2 implementation, @Nullable Object @NonNull [] theseValues, @Nullable Object result) {
            this.implementation = implementation;
            this.theseValues = theseValues;
            this.result = result;
        }

        public @Nullable Object getResult() {
            return this.result;
        }

        public boolean isEqual(@NonNull IdResolver idResolver, @NonNull LibraryOperation.LibraryOperationExtension2 implementation, @Nullable Object @NonNull [] thoseValues) {
            if (this.implementation != implementation) {
                return false;
            }
            Object[] thoseValues2 = thoseValues;
            int iMax = thoseValues2.length;
            Object[] theseValues2 = this.theseValues;
            if (iMax != theseValues2.length) {
                return false;
            }
            int i = 0;
            while (i < iMax) {
                if (!idResolver.oclEquals(theseValues2[i], thoseValues2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

