/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.internal.CompleteModelImpl;
import org.eclipse.ocl.pivot.internal.complete.AbstractCompletePackages;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;

public class RootCompletePackages
extends AbstractCompletePackages {
    private static final Logger logger = Logger.getLogger(RootCompletePackages.class);
    private static final long serialVersionUID = 1L;

    public RootCompletePackages(@NonNull CompleteModelImpl owner) {
        super(CompletePackage.class, owner, 6, 7);
    }

    @Override
    public @NonNull CompletePackageInternal createCompletePackage(@NonNull Package partialPackage) {
        CompletePackageInternal completePackage = (CompletePackageInternal)PivotFactory.eINSTANCE.createCompletePackage();
        completePackage.init(partialPackage.getName(), partialPackage.getNsPrefix(), partialPackage.getURI());
        return completePackage;
    }

    protected @NonNull CompletePackageInternal createRootCompletePackage(@NonNull Package pivotPackage) {
        if (Orphanage.isTypeOrphanage(pivotPackage)) {
            return this.getCompleteModel().getOrphanCompletePackage();
        }
        String name = pivotPackage.getName();
        String nonNullName = name;
        if (nonNullName == null) {
            nonNullName = "$anon_" + Integer.toHexString(System.identityHashCode(pivotPackage));
        }
        String nsPrefix = pivotPackage.getNsPrefix();
        String completeURI = this.getCompleteModel().getCompleteURIs().getCompleteURI(pivotPackage.getURI());
        CompletePackageInternal rootCompletePackage = (CompletePackageInternal)PivotFactory.eINSTANCE.createCompletePackage();
        rootCompletePackage.init(nonNullName, nsPrefix, completeURI);
        this.add(rootCompletePackage);
        return rootCompletePackage;
    }

    @Override
    protected void didAdd(@NonNull CompletePackage rootCompletePackage) {
        super.didAdd(rootCompletePackage);
    }

    @Override
    protected void didRemove(int index, CompletePackage rootCompletePackage) {
        assert (rootCompletePackage != null);
        super.didRemove(index, rootCompletePackage);
    }

    @Override
    public @NonNull CompleteModelInternal getCompleteModel() {
        return (CompleteModelInternal)this.owner;
    }

    @Override
    public @NonNull CompletePackageInternal getOwnedCompletePackage(@NonNull Package pivotPackage) {
        CompletePackageInternal rootCompletePackage;
        CompletePackageInternal completePackage = this.getCompleteModel().getCompleteURIs().getCompletePackage(pivotPackage);
        if (completePackage != null) {
            return completePackage;
        }
        String packageURI = pivotPackage.getURI();
        String name = pivotPackage.getName();
        if (name == null) {
            String message = null;
            Package eObject = pivotPackage;
            while (eObject != null) {
                if (eObject instanceof Model) {
                    message = "Unnamed package for '" + packageURI + "' in '" + ((Model)((Object)eObject)).getExternalURI() + "'";
                    break;
                }
                eObject = eObject.eContainer();
            }
            if (message == null) {
                message = "Unnamed package for '" + packageURI + "'";
            }
            logger.error(message);
            name = packageURI;
            if (name == null) {
                throw new IllegalStateException(message);
            }
        }
        if ((rootCompletePackage = this.getOwnedCompletePackage(name)) != null) {
            String completeURI2 = rootCompletePackage.getURI();
            if (packageURI == null || completeURI2 == null || packageURI.equals(completeURI2)) {
                return rootCompletePackage;
            }
        }
        rootCompletePackage = this.createRootCompletePackage(pivotPackage);
        return rootCompletePackage;
    }

    @Override
    protected @NonNull Iterable<Package> getPartialPackages() {
        return this.getCompleteModel().getPartialModels().getNestedPartialPackages();
    }
}

