/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.target;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class NewLaunchTargetWizardSelectionPage
extends WizardPage {
    private Table table;

    public NewLaunchTargetWizardSelectionPage() {
        super(NewLaunchTargetWizardSelectionPage.class.getName());
        this.setTitle(Messages.NewLaunchTargetWizardSelectionPage_Title);
        this.setDescription(Messages.NewLaunchTargetWizardSelectionPage_Description);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.table = new Table(comp, 2052);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.launchbar.ui.launchTargetTypeUI");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if ("wizard2".equals(elementName) || "wizard".equals(elementName)) {
                    elements.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        elements.sort(new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String name1 = o1.getAttribute("name");
                String name2 = o2.getAttribute("name");
                return name1.compareTo(name2);
            }
        });
        for (IConfigurationElement element : elements) {
            ImageDescriptor desc;
            String name = element.getAttribute("name");
            TableItem item = new TableItem(this.table, 0);
            item.setText(name);
            String iconFile = element.getAttribute("icon");
            if (iconFile != null && (desc = Activator.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)iconFile)) != null) {
                item.setImage(desc.createImage());
            }
            item.setData((Object)element);
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewLaunchTargetWizardSelectionPage.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (NewLaunchTargetWizardSelectionPage.this.canFlipToNextPage()) {
                    NewLaunchTargetWizardSelectionPage.this.getContainer().showPage(NewLaunchTargetWizardSelectionPage.this.getNextPage());
                }
            }
        });
        this.setControl((Control)comp);
    }

    public void dispose() {
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object obj = item.getData();
            if (obj instanceof Wizard) {
                ((Wizard)obj).dispose();
            }
            ++n2;
        }
        super.dispose();
    }

    public ImageDescriptor getDescriptionImage(IConfigurationElement element) {
        String descImage = element.getAttribute("icon");
        if (descImage == null) {
            return null;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)descImage);
    }

    public boolean canFlipToNextPage() {
        return this.table.getSelectionIndex() >= 0;
    }

    public IWizardPage getNextPage() {
        int i = this.table.getSelectionIndex();
        if (i >= 0) {
            Wizard nextWizard;
            TableItem item = this.table.getItem(i);
            Object obj = item.getData();
            if (obj instanceof IConfigurationElement) {
                IConfigurationElement element = (IConfigurationElement)obj;
                try {
                    nextWizard = (Wizard)element.createExecutableExtension("class");
                    nextWizard.addPages();
                    if (nextWizard instanceof IWorkbenchWizard) {
                        ((IWorkbenchWizard)nextWizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
                    }
                    item.setData((Object)nextWizard);
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                    return null;
                }
            } else {
                nextWizard = (Wizard)obj;
            }
            return nextWizard.getStartingPage();
        }
        return super.getNextPage();
    }
}

